/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.DeploymentCondition;
import io.fabric8.openshift.api.model.DeploymentConditionAssert;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentDetailsAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractDeploymentConfigStatusAssert<S extends AbstractDeploymentConfigStatusAssert<S, A>, A extends DeploymentConfigStatus>
extends AbstractAssert<S, A> {
    protected AbstractDeploymentConfigStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((DeploymentConfigStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasAvailableReplicas(Integer availableReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualAvailableReplicas = ((DeploymentConfigStatus)this.actual).getAvailableReplicas();
        if (!Objects.areEqual((Object)actualAvailableReplicas, (Object)availableReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, availableReplicas, actualAvailableReplicas});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }

    public NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<DeploymentCondition, DeploymentConditionAssert> assertFactory = new AssertFactory<DeploymentCondition, DeploymentConditionAssert>(){

            @Override
            public DeploymentConditionAssert createAssert(DeploymentCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> answer = new NavigationListAssert<DeploymentCondition, DeploymentConditionAssert>(((DeploymentConfigStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public DeploymentDetailsAssert details() {
        this.isNotNull();
        return (DeploymentDetailsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((DeploymentConfigStatus)this.actual).getDetails()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "details"), new Object[0]);
    }

    public S hasLatestVersion(Long latestVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting latestVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualLatestVersion = ((DeploymentConfigStatus)this.actual).getLatestVersion();
        if (!Objects.areEqual((Object)actualLatestVersion, (Object)latestVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, latestVersion, actualLatestVersion});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }

    public S hasObservedGeneration(Long observedGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualObservedGeneration = ((DeploymentConfigStatus)this.actual).getObservedGeneration();
        if (!Objects.areEqual((Object)actualObservedGeneration, (Object)observedGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, observedGeneration, actualObservedGeneration});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((DeploymentConfigStatus)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }

    public S hasUnavailableReplicas(Integer unavailableReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting unavailableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualUnavailableReplicas = ((DeploymentConfigStatus)this.actual).getUnavailableReplicas();
        if (!Objects.areEqual((Object)actualUnavailableReplicas, (Object)unavailableReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, unavailableReplicas, actualUnavailableReplicas});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }

    public S hasUpdatedReplicas(Integer updatedReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualUpdatedReplicas = ((DeploymentConfigStatus)this.actual).getUpdatedReplicas();
        if (!Objects.areEqual((Object)actualUpdatedReplicas, (Object)updatedReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, updatedReplicas, actualUpdatedReplicas});
        }
        return (S)((Object)((AbstractDeploymentConfigStatusAssert)this.myself));
    }
}

