/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public interface WebSocket {
    public boolean send(ByteBuffer var1);

    public boolean sendClose(int var1, String var2);

    public long queueSize();

    public void request();

    public static URI toWebSocketUri(URI httpUri) {
        if (httpUri != null && httpUri.getScheme().startsWith("http")) {
            return URI.create("ws" + httpUri.toString().substring(4));
        }
        return httpUri;
    }

    public static interface Builder
    extends BasicBuilder {
        public CompletableFuture<WebSocket> buildAsync(Listener var1);

        public Builder subprotocol(String var1);

        @Override
        public Builder header(String var1, String var2);

        @Override
        public Builder setHeader(String var1, String var2);

        @Override
        public Builder uri(URI var1);

        public Builder connectTimeout(long var1, TimeUnit var3);
    }

    public static interface Listener {
        default public void onOpen(WebSocket webSocket) {
        }

        default public void onMessage(WebSocket webSocket, String text) {
            webSocket.request();
        }

        default public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
            webSocket.request();
        }

        default public void onClose(WebSocket webSocket, int code, String reason) {
        }

        default public void onError(WebSocket webSocket, Throwable error) {
        }
    }
}

