/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.SecretReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReferenceFluentImpl;
import java.util.Objects;

public class SecretReferenceBuilder
extends SecretReferenceFluentImpl<SecretReferenceBuilder>
implements VisitableBuilder<SecretReference, SecretReferenceBuilder> {
    SecretReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public SecretReferenceBuilder() {
        this(true);
    }

    public SecretReferenceBuilder(Boolean validationEnabled) {
        this(new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretReference(), validationEnabled);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance) {
        this(fluent, instance, true);
    }

    public SecretReferenceBuilder(SecretReferenceFluent<?> fluent, SecretReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public SecretReferenceBuilder(SecretReference instance) {
        this(instance, (Boolean)true);
    }

    public SecretReferenceBuilder(SecretReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretReference build() {
        SecretReference buildable = new SecretReference(this.fluent.getName(), this.fluent.getNamespace());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretReferenceBuilder that = (SecretReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

