package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterBuilder extends io.fabric8.kubernetes.api.model.ClusterFluentImpl<io.fabric8.kubernetes.api.model.ClusterBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.Cluster,io.fabric8.kubernetes.api.model.ClusterBuilder>{
  public ClusterBuilder() {
    this(false);
  }
  public ClusterBuilder(java.lang.Boolean validationEnabled) {
    this(new Cluster(), validationEnabled);
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.ClusterFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.ClusterFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Cluster(), validationEnabled);
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.ClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.Cluster instance) {
    this(fluent, instance, false);
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.ClusterFluent<?> fluent,io.fabric8.kubernetes.api.model.Cluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificateAuthority(instance.getCertificateAuthority()); 
    fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
    fluent.withExtensions(instance.getExtensions()); 
    fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
    fluent.withProxyUrl(instance.getProxyUrl()); 
    fluent.withServer(instance.getServer()); 
    fluent.withTlsServerName(instance.getTlsServerName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.Cluster instance) {
    this(instance,false);
  }
  public ClusterBuilder(io.fabric8.kubernetes.api.model.Cluster instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificateAuthority(instance.getCertificateAuthority()); 
    this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
    this.withExtensions(instance.getExtensions()); 
    this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withServer(instance.getServer()); 
    this.withTlsServerName(instance.getTlsServerName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ClusterFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Cluster build() {
    Cluster buildable = new Cluster(fluent.getCertificateAuthority(),fluent.getCertificateAuthorityData(),fluent.getExtensions(),fluent.getInsecureSkipTlsVerify(),fluent.getProxyUrl(),fluent.getServer(),fluent.getTlsServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterBuilder that = (ClusterBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}