package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class ComponentStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.ComponentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ComponentStatusFluent<A>{
  public ComponentStatusFluentImpl() {
  }
  public ComponentStatusFluentImpl(io.fabric8.kubernetes.api.model.ComponentStatus instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withConditions(instance.getConditions()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>();}
    io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>();}
    io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.ComponentCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.ComponentCondition item : items) {io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.ComponentCondition item : items) {io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.ComponentCondition... items) {
    for (io.fabric8.kubernetes.api.model.ComponentCondition item : items) {io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.ComponentCondition> items) {
    for (io.fabric8.kubernetes.api.model.ComponentCondition item : items) {io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.ComponentCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ComponentCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.ComponentCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ComponentCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ComponentCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ComponentCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ComponentConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ComponentConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.ComponentCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ComponentConditionBuilder>(); for (io.fabric8.kubernetes.api.model.ComponentCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.ComponentCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.ComponentCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String error,java.lang.String message,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new ComponentCondition(error, message, status, type));
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.ComponentCondition item) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentCondition item) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ComponentConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ComponentStatusFluentImpl that = (ComponentStatusFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  conditions,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.ComponentConditionFluentImpl<io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.ComponentStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ComponentCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ComponentConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ComponentConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ComponentStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.ComponentStatusFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ComponentStatusFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}