package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ExecConfigBuilder extends io.fabric8.kubernetes.api.model.ExecConfigFluentImpl<io.fabric8.kubernetes.api.model.ExecConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ExecConfig,io.fabric8.kubernetes.api.model.ExecConfigBuilder>{
  public ExecConfigBuilder() {
    this(false);
  }
  public ExecConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new ExecConfig(), validationEnabled);
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExecConfig(), validationEnabled);
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecConfig instance) {
    this(fluent, instance, false);
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.ExecConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withArgs(instance.getArgs()); 
    fluent.withCommand(instance.getCommand()); 
    fluent.withEnv(instance.getEnv()); 
    fluent.withInstallHint(instance.getInstallHint()); 
    fluent.withInteractiveMode(instance.getInteractiveMode()); 
    fluent.withProvideClusterInfo(instance.getProvideClusterInfo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfig instance) {
    this(instance,false);
  }
  public ExecConfigBuilder(io.fabric8.kubernetes.api.model.ExecConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withArgs(instance.getArgs()); 
    this.withCommand(instance.getCommand()); 
    this.withEnv(instance.getEnv()); 
    this.withInstallHint(instance.getInstallHint()); 
    this.withInteractiveMode(instance.getInteractiveMode()); 
    this.withProvideClusterInfo(instance.getProvideClusterInfo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ExecConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ExecConfig build() {
    ExecConfig buildable = new ExecConfig(fluent.getApiVersion(),fluent.getArgs(),fluent.getCommand(),fluent.getEnv(),fluent.getInstallHint(),fluent.getInteractiveMode(),fluent.getProvideClusterInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExecConfigBuilder that = (ExecConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}