package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PatchOptionsBuilder extends io.fabric8.kubernetes.api.model.PatchOptionsFluentImpl<io.fabric8.kubernetes.api.model.PatchOptionsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PatchOptions,io.fabric8.kubernetes.api.model.PatchOptionsBuilder>{
  public PatchOptionsBuilder() {
    this(false);
  }
  public PatchOptionsBuilder(java.lang.Boolean validationEnabled) {
    this(new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PatchOptions(), validationEnabled);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PatchOptions instance) {
    this(fluent, instance, false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PatchOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDryRun(instance.getDryRun()); 
    fluent.withFieldManager(instance.getFieldManager()); 
    fluent.withForce(instance.getForce()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptions instance) {
    this(instance,false);
  }
  public PatchOptionsBuilder(io.fabric8.kubernetes.api.model.PatchOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDryRun(instance.getDryRun()); 
    this.withFieldManager(instance.getFieldManager()); 
    this.withForce(instance.getForce()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PatchOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PatchOptions build() {
    PatchOptions buildable = new PatchOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getForce(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PatchOptionsBuilder that = (PatchOptionsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}