/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.CreateOptions;
import io.fabric8.kubernetes.api.model.CreateOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CreateOptionsFluentImpl<A extends CreateOptionsFluent<A>>
extends BaseFluent<A>
implements CreateOptionsFluent<A> {
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private String fieldManager;
    private String kind;
    private Map<String, Object> additionalProperties;

    public CreateOptionsFluentImpl() {
    }

    public CreateOptionsFluentImpl(CreateOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDryRun(instance.getDryRun());
        this.withFieldManager(instance.getFieldManager());
        this.withKind(instance.getKind());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDryRun(Integer index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDryRun(String ... items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDryRun(Collection<String> items) {
        for (String item : items) {
            if (this.dryRun == null) continue;
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDryRun() {
        return this.dryRun;
    }

    @Override
    public String getDryRun(Integer index) {
        return this.dryRun.get(index);
    }

    @Override
    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    @Override
    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    @Override
    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    @Override
    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    @Override
    public A addNewDryRun(String arg0) {
        return this.addToDryRun(new String(arg0));
    }

    @Override
    public String getFieldManager() {
        return this.fieldManager;
    }

    @Override
    public A withFieldManager(String fieldManager) {
        this.fieldManager = fieldManager;
        return (A)this;
    }

    @Override
    public Boolean hasFieldManager() {
        return this.fieldManager != null;
    }

    @Override
    @Deprecated
    public A withNewFieldManager(String arg0) {
        return this.withFieldManager(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOptionsFluentImpl that = (CreateOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dryRun != null ? !this.dryRun.equals(that.dryRun) : that.dryRun != null) {
            return false;
        }
        if (this.fieldManager != null ? !this.fieldManager.equals(that.fieldManager) : that.fieldManager != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.fieldManager, this.kind, this.additionalProperties, super.hashCode());
    }
}

