/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedClusterFluentImpl;
import java.util.Objects;

public class NamedClusterBuilder
extends NamedClusterFluentImpl<NamedClusterBuilder>
implements VisitableBuilder<NamedCluster, NamedClusterBuilder> {
    NamedClusterFluent<?> fluent;
    Boolean validationEnabled;

    public NamedClusterBuilder() {
        this(false);
    }

    public NamedClusterBuilder(Boolean validationEnabled) {
        this(new NamedCluster(), validationEnabled);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedCluster(), validationEnabled);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance) {
        this(fluent, instance, false);
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withName(instance.getName());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public NamedClusterBuilder(NamedCluster instance) {
        this(instance, (Boolean)false);
    }

    public NamedClusterBuilder(NamedCluster instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withName(instance.getName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NamedCluster build() {
        NamedCluster buildable = new NamedCluster(this.fluent.getCluster(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterBuilder that = (NamedClusterBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

