package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class QuobyteVolumeSourceBuilder extends QuobyteVolumeSourceFluent<QuobyteVolumeSourceBuilder> implements VisitableBuilder<QuobyteVolumeSource,QuobyteVolumeSourceBuilder>{
  public QuobyteVolumeSourceBuilder() {
    this(new QuobyteVolumeSource());
  }
  
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent) {
    this(fluent, new QuobyteVolumeSource());
  }
  
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent,QuobyteVolumeSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  QuobyteVolumeSourceFluent<?> fluent;
  
  public QuobyteVolumeSource build() {
    QuobyteVolumeSource buildable = new QuobyteVolumeSource(fluent.getGroup(),fluent.getReadOnly(),fluent.getRegistry(),fluent.getTenant(),fluent.getUser(),fluent.getVolume());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}