package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ObjectFieldSelectorBuilder extends ObjectFieldSelectorFluent<ObjectFieldSelectorBuilder> implements VisitableBuilder<ObjectFieldSelector,ObjectFieldSelectorBuilder>{
  public ObjectFieldSelectorBuilder() {
    this(new ObjectFieldSelector());
  }
  
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent) {
    this(fluent, new ObjectFieldSelector());
  }
  
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent,ObjectFieldSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ObjectFieldSelectorBuilder(ObjectFieldSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ObjectFieldSelectorFluent<?> fluent;
  
  public ObjectFieldSelector build() {
    ObjectFieldSelector buildable = new ObjectFieldSelector(fluent.getApiVersion(),fluent.getFieldPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}