/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EndpointAddressFluent<A extends EndpointAddressFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private String ip;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;
    private Map<String, Object> additionalProperties;

    public EndpointAddressFluent() {
    }

    public EndpointAddressFluent(EndpointAddress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EndpointAddress instance) {
        EndpointAddress endpointAddress = instance = instance != null ? instance : new EndpointAddress();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withIp(instance.getIp());
            this.withNodeName(instance.getNodeName());
            this.withTargetRef(instance.getTargetRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)((Object)this);
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.remove((Object)"targetRef");
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get((Object)"targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get((Object)"targetRef").remove((Object)this.targetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNested(null);
    }

    public TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNested(item);
    }

    public TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(null));
    }

    public TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressFluent that = (EndpointAddressFluent)((Object)o);
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals((Object)this.targetRef, (Object)that.targetRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostname, this.ip, this.nodeName, this.targetRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append((Object)((Object)this.targetRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefNested<N>
    extends ObjectReferenceFluent<TargetRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        TargetRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)EndpointAddressFluent.this.withTargetRef(this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }
}

