package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CreateOptionsBuilder extends CreateOptionsFluent<CreateOptionsBuilder> implements VisitableBuilder<CreateOptions,CreateOptionsBuilder>{
  public CreateOptionsBuilder() {
    this(new CreateOptions());
  }
  
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent) {
    this(fluent, new CreateOptions());
  }
  
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,CreateOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CreateOptionsBuilder(CreateOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CreateOptionsFluent<?> fluent;
  
  public CreateOptions build() {
    CreateOptions buildable = new CreateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}