package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VolumeMountBuilder extends VolumeMountFluent<VolumeMountBuilder> implements VisitableBuilder<VolumeMount,VolumeMountBuilder>{
  public VolumeMountBuilder() {
    this(new VolumeMount());
  }
  
  public VolumeMountBuilder(VolumeMountFluent<?> fluent) {
    this(fluent, new VolumeMount());
  }
  
  public VolumeMountBuilder(VolumeMountFluent<?> fluent,VolumeMount instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VolumeMountBuilder(VolumeMount instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VolumeMountFluent<?> fluent;
  
  public VolumeMount build() {
    VolumeMount buildable = new VolumeMount(fluent.getMountPath(),fluent.getMountPropagation(),fluent.getName(),fluent.getReadOnly(),fluent.getRecursiveReadOnly(),fluent.getSubPath(),fluent.getSubPathExpr());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}