/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.dsl.Emitable;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.Function;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import io.fabric8.mockwebserver.internal.WebSocketMessage;
import io.fabric8.mockwebserver.internal.WebSocketSession;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class InlineWebSocketSessionBuilder<T>
implements WebSocketSessionBuilder<T>,
EventDoneable<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ScheduledExecutorService executor;
    private final Context context;
    private final Function<WebSocketSession, T> function;
    private WebSocketSession session;

    public InlineWebSocketSessionBuilder(Context context, ScheduledExecutorService executor, Function<WebSocketSession, T> function) {
        this.context = context;
        this.function = function;
        this.executor = executor;
    }

    public InlineWebSocketSessionBuilder(Context context, Function<WebSocketSession, T> function) {
        this.context = context;
        this.function = function;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public EventDoneable<T> open(Object ... response) {
        this.session = new WebSocketSession(this.context, this.executor, this.toWebSocketMessages(response), null, null);
        return this;
    }

    @Override
    public T failure(Object response, Exception e) {
        return this.function.apply(new WebSocketSession(this.context, this.executor, Collections.emptyList(), this.toWebSocketMessage(response), e));
    }

    @Override
    public T done() {
        return this.function.apply(this.session);
    }

    @Override
    public Emitable<TimesOrOnceable<EventDoneable<T>>> expect(final Object in) {
        return new Emitable<TimesOrOnceable<EventDoneable<T>>>(){

            @Override
            public TimesOrOnceable<EventDoneable<T>> andEmit(final Object event) {
                return new TimesOrOnceable<EventDoneable<T>>(){

                    @Override
                    public EventDoneable<T> always() {
                        InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, false));
                        return InlineWebSocketSessionBuilder.this;
                    }

                    @Override
                    public EventDoneable<T> once() {
                        InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, true));
                        return InlineWebSocketSessionBuilder.this;
                    }

                    @Override
                    public EventDoneable<T> times(int times) {
                        for (int i = 0; i < times; ++i) {
                            InlineWebSocketSessionBuilder.this.enqueue(in, InlineWebSocketSessionBuilder.this.toWebSocketMessage(event, true));
                        }
                        return InlineWebSocketSessionBuilder.this;
                    }
                };
            }
        };
    }

    @Override
    public Emitable<EventDoneable<T>> waitFor(final long millis) {
        return new Emitable<EventDoneable<T>>(){

            @Override
            public EventDoneable<T> andEmit(Object event) {
                InlineWebSocketSessionBuilder.this.session.getTimedEvents().add(InlineWebSocketSessionBuilder.this.toWebSocketMessage(millis, event));
                return InlineWebSocketSessionBuilder.this;
            }
        };
    }

    @Override
    public Emitable<EventDoneable<T>> immediately() {
        return this.waitFor(0L);
    }

    private List<WebSocketMessage> toWebSocketMessages(Object ... messages) {
        ArrayList<WebSocketMessage> response = new ArrayList<WebSocketMessage>();
        for (Object msg : messages) {
            response.add(this.toWebSocketMessage(msg));
        }
        return response;
    }

    private WebSocketMessage toWebSocketMessage(Object content) {
        return this.toWebSocketMessage(0L, content, true);
    }

    private WebSocketMessage toWebSocketMessage(Long delay, Object content) {
        return this.toWebSocketMessage(delay, content, true);
    }

    private WebSocketMessage toWebSocketMessage(Object content, Boolean toBeRemoved) {
        return this.toWebSocketMessage(0L, content, toBeRemoved);
    }

    private WebSocketMessage toWebSocketMessage(Long delay, Object content, Boolean toBeRemoved) {
        if (content instanceof String) {
            return new WebSocketMessage(delay, (String)content, (boolean)toBeRemoved);
        }
        if (content instanceof WebSocketMessage) {
            return (WebSocketMessage)content;
        }
        try {
            return this.toWebSocketMessage(delay, MAPPER.writeValueAsString(content), toBeRemoved);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void enqueue(Object req, WebSocketMessage resp) {
        Queue<WebSocketMessage> queuedResponses = this.session.getRequestEvents().get(req);
        if (queuedResponses == null) {
            queuedResponses = new ArrayDeque<WebSocketMessage>();
            this.session.getRequestEvents().put(req, queuedResponses);
        }
        queuedResponses.add(resp);
    }
}

