/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsoleSampleSource;
import io.fabric8.openshift.api.model.console.v1.ConsoleSampleSourceBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleSampleSourceFluent;
import io.fabric8.openshift.api.model.console.v1.ConsoleSampleSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsoleSampleSpecFluent<A extends ConsoleSampleSpecFluent<A>>
extends BaseFluent<A> {
    private String _abstract;
    private String description;
    private String icon;
    private String provider;
    private ConsoleSampleSourceBuilder source;
    private List<String> tags = new ArrayList<String>();
    private String title;
    private String type;
    private Map<String, Object> additionalProperties;

    public ConsoleSampleSpecFluent() {
    }

    public ConsoleSampleSpecFluent(ConsoleSampleSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsoleSampleSpec instance) {
        ConsoleSampleSpec consoleSampleSpec = instance = instance != null ? instance : new ConsoleSampleSpec();
        if (instance != null) {
            this.withAbstract(instance.getAbstract());
            this.withDescription(instance.getDescription());
            this.withIcon(instance.getIcon());
            this.withProvider(instance.getProvider());
            this.withSource(instance.getSource());
            this.withTags(instance.getTags());
            this.withTitle(instance.getTitle());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAbstract() {
        return this._abstract;
    }

    public A withAbstract(String _abstract) {
        this._abstract = _abstract;
        return (A)((Object)this);
    }

    public boolean hasAbstract() {
        return this._abstract != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getIcon() {
        return this.icon;
    }

    public A withIcon(String icon) {
        this.icon = icon;
        return (A)((Object)this);
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public String getProvider() {
        return this.provider;
    }

    public A withProvider(String provider) {
        this.provider = provider;
        return (A)((Object)this);
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public ConsoleSampleSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(ConsoleSampleSource source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new ConsoleSampleSourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(ConsoleSampleSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new ConsoleSampleSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(ConsoleSampleSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleSampleSpecFluent that = (ConsoleSampleSpecFluent)((Object)o);
        if (!Objects.equals(this._abstract, that._abstract)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.icon, that.icon)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._abstract, this.description, this.icon, this.provider, this.source, this.tags, this.title, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._abstract != null) {
            sb.append("_abstract:");
            sb.append(this._abstract + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append(this.icon + ",");
        }
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(this.provider + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends ConsoleSampleSourceFluent<SourceNested<N>>
    implements Nested<N> {
        ConsoleSampleSourceBuilder builder;

        SourceNested(ConsoleSampleSource item) {
            this.builder = new ConsoleSampleSourceBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleSampleSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

