/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RemoteReadSpecFluent<A extends RemoteReadSpecFluent<A>>
extends BaseFluent<A> {
    private AuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private Boolean filterExternalLabels;
    private Boolean followRedirects;
    private Map<String, String> headers;
    private String name;
    private OAuth2Builder oauth2;
    private String proxyUrl;
    private Boolean readRecent;
    private String remoteTimeout;
    private Map<String, String> requiredMatchers;
    private TLSConfigBuilder tlsConfig;
    private String url;
    private Map<String, Object> additionalProperties;

    public RemoteReadSpecFluent() {
    }

    public RemoteReadSpecFluent(RemoteReadSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RemoteReadSpec instance) {
        RemoteReadSpec remoteReadSpec = instance = instance != null ? instance : new RemoteReadSpec();
        if (instance != null) {
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerToken(instance.getBearerToken());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withFilterExternalLabels(instance.getFilterExternalLabels());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withHeaders(instance.getHeaders());
            this.withName(instance.getName());
            this.withOauth2(instance.getOauth2());
            this.withProxyUrl(instance.getProxyUrl());
            this.withReadRecent(instance.getReadRecent());
            this.withRemoteTimeout(instance.getRemoteTimeout());
            this.withRequiredMatchers(instance.getRequiredMatchers());
            this.withTlsConfig(instance.getTlsConfig());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(Authorization authorization) {
        this._visitables.remove((Object)"authorization");
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new AuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove((Object)"basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get((Object)"basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get((Object)"basicAuth").remove((Object)this.basicAuth);
        }
        return (A)((Object)this);
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public A withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return (A)((Object)this);
    }

    public boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)((Object)this);
    }

    public boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public Boolean getFilterExternalLabels() {
        return this.filterExternalLabels;
    }

    public A withFilterExternalLabels(Boolean filterExternalLabels) {
        this.filterExternalLabels = filterExternalLabels;
        return (A)((Object)this);
    }

    public boolean hasFilterExternalLabels() {
        return this.filterExternalLabels != null;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)((Object)this);
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public A addToHeaders(String key, String value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, String> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, String> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, String> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, String>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove((Object)"oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get((Object)"oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get((Object)"oauth2").remove((Object)this.oauth2);
        }
        return (A)((Object)this);
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)((Object)this);
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public Boolean getReadRecent() {
        return this.readRecent;
    }

    public A withReadRecent(Boolean readRecent) {
        this.readRecent = readRecent;
        return (A)((Object)this);
    }

    public boolean hasReadRecent() {
        return this.readRecent != null;
    }

    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
        return (A)((Object)this);
    }

    public boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    public A addToRequiredMatchers(String key, String value) {
        if (this.requiredMatchers == null && key != null && value != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.requiredMatchers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null && map != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.requiredMatchers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromRequiredMatchers(String key) {
        if (this.requiredMatchers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.requiredMatchers != null) {
            this.requiredMatchers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requiredMatchers == null) continue;
                this.requiredMatchers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getRequiredMatchers() {
        return this.requiredMatchers;
    }

    public <K, V> A withRequiredMatchers(Map<String, String> requiredMatchers) {
        this.requiredMatchers = requiredMatchers == null ? null : new LinkedHashMap<String, String>(requiredMatchers);
        return (A)((Object)this);
    }

    public boolean hasRequiredMatchers() {
        return this.requiredMatchers != null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteReadSpecFluent that = (RemoteReadSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.authorization, (Object)that.authorization)) {
            return false;
        }
        if (!Objects.equals((Object)this.basicAuth, (Object)that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerToken, that.bearerToken)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.filterExternalLabels, that.filterExternalLabels)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.oauth2, (Object)that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.readRecent, that.readRecent)) {
            return false;
        }
        if (!Objects.equals(this.remoteTimeout, that.remoteTimeout)) {
            return false;
        }
        if (!Objects.equals(this.requiredMatchers, that.requiredMatchers)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorization, this.basicAuth, this.bearerToken, this.bearerTokenFile, this.filterExternalLabels, this.followRedirects, this.headers, this.name, this.oauth2, this.proxyUrl, this.readRecent, this.remoteTimeout, this.requiredMatchers, this.tlsConfig, this.url, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append((Object)((Object)this.authorization) + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append((Object)((Object)this.basicAuth) + ",");
        }
        if (this.bearerToken != null) {
            sb.append("bearerToken:");
            sb.append(this.bearerToken + ",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile + ",");
        }
        if (this.filterExternalLabels != null) {
            sb.append("filterExternalLabels:");
            sb.append(this.filterExternalLabels + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append((Object)((Object)this.oauth2) + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.readRecent != null) {
            sb.append("readRecent:");
            sb.append(this.readRecent + ",");
        }
        if (this.remoteTimeout != null) {
            sb.append("remoteTimeout:");
            sb.append(this.remoteTimeout + ",");
        }
        if (this.requiredMatchers != null && !this.requiredMatchers.isEmpty()) {
            sb.append("requiredMatchers:");
            sb.append(this.requiredMatchers + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)((Object)this.tlsConfig) + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withFilterExternalLabels() {
        return this.withFilterExternalLabels(true);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withReadRecent() {
        return this.withReadRecent(true);
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)RemoteReadSpecFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        public N and() {
            return (N)RemoteReadSpecFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        public N and() {
            return (N)RemoteReadSpecFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends AuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNested(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)RemoteReadSpecFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

