/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class MessageEndPartImpl
extends PartImpl {
    private ByteBuf contentBuffer;

    public MessageEndPartImpl(byte[] byArray) {
        super(null, byArray);
        this.state = PartImplState.PRE_CONTENT;
    }

    @Override
    public void copyInto(ByteBuf byteBuf) {
        this.copyInto(this.lazyLoadContentBuffer(byteBuf.alloc()), byteBuf, PartImplState.DONE);
    }

    @Override
    public long transferTo(WritableByteChannel writableByteChannel) throws IOException {
        this.slowTarget = false;
        return this.transferTo(this.lazyLoadContentBuffer(ByteBufAllocator.DEFAULT), writableByteChannel, PartImplState.DONE);
    }

    private ByteBuf lazyLoadContentBuffer(ByteBufAllocator byteBufAllocator) {
        if (this.contentBuffer == null) {
            this.contentBuffer = byteBufAllocator.buffer((int)this.getContentLength());
            this.contentBuffer.writeBytes(EXTRA_BYTES).writeBytes(this.boundary).writeBytes(EXTRA_BYTES).writeBytes(CRLF_BYTES);
        }
        return this.contentBuffer;
    }

    @Override
    protected int computePreContentLength() {
        return 0;
    }

    @Override
    protected ByteBuf computePreContentBytes(int n) {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected int computePostContentLength() {
        return 0;
    }

    @Override
    protected ByteBuf computePostContentBytes(int n) {
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    protected long getContentLength() {
        return EXTRA_BYTES.length + this.boundary.length + EXTRA_BYTES.length + CRLF_BYTES.length;
    }

    @Override
    protected void copyContentInto(ByteBuf byteBuf) {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    protected long transferContentTo(WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException("Not supposed to be called");
    }

    @Override
    public void close() {
        super.close();
        if (this.contentBuffer != null) {
            this.contentBuffer.release();
        }
    }
}

