/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.realm;

import io.gatling.http.client.realm.DigestAuth;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpMethod;

public class DigestRealm
implements Realm {
    private final String username;
    private final String password;

    public DigestRealm(String string, String string2) {
        this.username = string;
        this.password = string2;
    }

    public String computeAuthorizationHeader(HttpMethod httpMethod, Uri uri, String string) {
        return new DigestAuth(this.username, this.password, DigestRealm.match(string, "realm"), DigestRealm.match(string, "nonce"), DigestRealm.match(string, "opaque"), DigestRealm.match(string, "algorithm"), DigestRealm.parseRawQop(DigestRealm.match(string, "qop")), "00000001", httpMethod, uri.toRelativeUrl()).computeAuthorization();
    }

    private static String match(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n <= 0) {
            return null;
        }
        int n2 = string.indexOf(",", n += string2.length() + 1);
        String string3 = string.substring(n, n2 > 0 ? n2 : string.length());
        string3 = string3.length() > 0 && string3.charAt(string3.length() - 1) == '\"' ? string3.substring(0, string3.length() - 1) : string3;
        return string3.charAt(0) == '\"' ? string3.substring(1) : string3;
    }

    private static String parseRawQop(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
        }
        for (String string2 : stringArray2) {
            if (!string2.equals("auth")) continue;
            return string2;
        }
        for (String string2 : stringArray2) {
            if (!string2.equals("auth-int")) continue;
            return string2;
        }
        return null;
    }
}

