/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.app.CommandLineConstants;
import io.gatling.app.GatlingStatusCodes;
import io.gatling.mojo.GatlingJavaMainCallerByFork;
import io.gatling.mojo.GatlingJavaMainCallerInProcess;
import io.gatling.mojo.GatlingSimulationAssertionsFailedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.MainHelper;
import scala_maven_executions.MainWithArgsInFile;

@Mojo(name="execute", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class GatlingMojo
extends AbstractMojo {
    public static final String[] SCALA_INCLUDES = new String[]{"**/*.scala"};
    public static final String GATLING_MAIN_CLASS = "io.gatling.app.Gatling";
    public static final String[] JVM_ARGS = new String[]{"-server", "-XX:+UseThreadPriorities", "-XX:ThreadPriorityPolicy=42", "-Xms512M", "-Xmx512M", "-Xmn100M", "-XX:+HeapDumpOnOutOfMemoryError", "-XX:+AggressiveOpts", "-XX:+OptimizeStringConcat", "-XX:+UseFastAccessorMethods", "-XX:+UseParNewGC", "-XX:+UseConcMarkSweepGC", "-XX:+CMSParallelRemarkEnabled"};
    @Parameter(property="gatling.noReports", alias="nr", defaultValue="false")
    private boolean noReports;
    @Parameter(property="gatling.reportsOnly", alias="ro")
    private String reportsOnly;
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${basedir}/src/test/resources")
    private File configFolder;
    @Parameter(property="gatling.simulationsFolder", alias="sf", defaultValue="${basedir}/src/test/scala")
    private File simulationsFolder;
    @Parameter(property="gatling.simulationClass", alias="sc")
    private String simulationClass;
    @Parameter(property="gatling.dataFolder", alias="df", defaultValue="${basedir}/src/test/resources/data")
    private File dataFolder;
    @Parameter(property="gatling.requestBodiesFolder", alias="bf", defaultValue="${basedir}/src/test/resources/request-bodies")
    private File requestBodiesFolder;
    @Parameter(property="gatling.resultsFolder", alias="rf", defaultValue="${basedir}/target/gatling/results")
    private File resultsFolder;
    @Parameter(property="gatling.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="gatling.fork", defaultValue="true")
    private boolean fork;
    @Parameter(property="gatling.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="gatling.outputName", alias="on")
    private String outputDirectoryBaseName;
    @Parameter(property="gatling.propagateSystemProperties", defaultValue="true")
    private boolean propagateSystemProperties;
    @Parameter(property="gatling.skip", defaultValue="false")
    private boolean skip;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.resultsFolder.mkdirs();
            try {
                this.executeGatling(this.jvmArgs().toArray(new String[this.jvmArgs.size()]), this.gatlingArgs().toArray(new String[this.jvmArgs.size()]));
            }
            catch (Exception e) {
                if (this.failOnError) {
                    throw new MojoExecutionException("Gatling failed.", e);
                }
                this.getLog().warn((CharSequence)"There was some errors while running your simulation, but failOnError set to false won't fail your build.");
            }
        } else {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
        }
    }

    private void executeGatling(String[] jvmArgs, String[] gatlingArgs) throws Exception {
        String testClasspath = this.buildTestClasspath();
        if (this.fork) {
            Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            GatlingJavaMainCallerByFork caller = new GatlingJavaMainCallerByFork(this, GATLING_MAIN_CLASS, testClasspath, jvmArgs, gatlingArgs, false, toolchain, this.propagateSystemProperties);
            try {
                caller.run(false);
            }
            catch (ExecuteException e) {
                if (e.getExitValue() == GatlingStatusCodes.AssertionsFailed()) {
                    throw new GatlingSimulationAssertionsFailedException(e);
                }
                throw e;
            }
        } else {
            GatlingJavaMainCallerInProcess caller = new GatlingJavaMainCallerInProcess(this, GATLING_MAIN_CLASS, testClasspath, gatlingArgs);
            int returnCode = caller.run();
            if (returnCode == GatlingStatusCodes.AssertionsFailed()) {
                throw new GatlingSimulationAssertionsFailedException();
            }
        }
    }

    private String buildTestClasspath() throws Exception {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        testClasspathElements.add(this.configFolder.getPath());
        testClasspathElements.add(MainHelper.locateJar(GatlingMojo.class));
        testClasspathElements.add(MainHelper.locateJar(MainWithArgsInFile.class));
        return MainHelper.toMultiPath((List)testClasspathElements);
    }

    private List<String> jvmArgs() {
        return this.jvmArgs != null ? this.jvmArgs : Arrays.asList(JVM_ARGS);
    }

    private List<String> gatlingArgs() throws Exception {
        if (this.simulationClass == null) {
            List<String> simulations = this.resolveSimulations(this.simulationsFolder);
            if (simulations.isEmpty()) {
                this.getLog().error((CharSequence)"No simulations to run");
                throw new MojoFailureException("No simulations to run");
            }
            if (simulations.size() > 1) {
                this.getLog().error((CharSequence)"More than 1 simulation to run, need to specify one");
                throw new MojoFailureException("More than 1 simulation to run, need to specify one");
            }
            this.simulationClass = simulations.get(0);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList('-' + CommandLineConstants.DataFolder().abbr(), this.dataFolder.getCanonicalPath(), '-' + CommandLineConstants.ResultsFolder().abbr(), this.resultsFolder.getCanonicalPath(), '-' + CommandLineConstants.RequestBodiesFolder().abbr(), this.requestBodiesFolder.getCanonicalPath(), '-' + CommandLineConstants.SimulationsFolder().abbr(), this.simulationsFolder.getCanonicalPath(), '-' + CommandLineConstants.Simulation().abbr(), this.simulationClass));
        if (this.noReports) {
            args.add("-" + CommandLineConstants.NoReports().abbr());
        }
        if (this.reportsOnly != null) {
            args.addAll(Arrays.asList("-" + CommandLineConstants.ReportsOnly().abbr(), this.reportsOnly));
        }
        if (this.outputDirectoryBaseName != null) {
            args.addAll(Arrays.asList("--" + CommandLineConstants.OutputDirectoryBaseName().abbr(), this.outputDirectoryBaseName));
        }
        return args;
    }

    public static String fileNameToClassName(String fileName) {
        String trimmedFileName = StringUtils.trim((String)fileName);
        int lastIndexOfExtensionDelim = trimmedFileName.lastIndexOf(".");
        String strippedFileName = lastIndexOfExtensionDelim > 0 ? trimmedFileName.substring(0, lastIndexOfExtensionDelim) : trimmedFileName;
        return strippedFileName.replace(File.separatorChar, '.');
    }

    private List<String> resolveSimulations(File simulationsFolder) {
        DirectoryScanner scanner = new DirectoryScanner();
        this.getLog().debug((CharSequence)("effective simulationsFolder: " + simulationsFolder.getPath()));
        scanner.setBasedir(simulationsFolder);
        scanner.setIncludes(SCALA_INCLUDES);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        ArrayList<String> includedClassNames = new ArrayList<String>();
        for (String includedFile : includedFiles) {
            includedClassNames.add(GatlingMojo.fileNameToClassName(includedFile));
        }
        this.getLog().debug((CharSequence)("resolved simulation classes: " + includedClassNames));
        return includedClassNames;
    }
}

