/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.MainWithArgsInFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;

public class Fork {
    private static final String ARG_FILE_PREFIX = "gatling-maven-plugin-";
    private static final String ARG_FILE_SUFFIX = ".args";
    private final String javaExecutable;
    private final String mainClassName;
    private final List<String> jvmArgs = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    public Fork(String mainClassName, String classpath, List<String> jvmArgs, List<String> args, Toolchain toolchain, boolean propagateSystemProperties) throws Exception {
        this.javaExecutable = this.findJavaExecutable(toolchain);
        this.mainClassName = mainClassName;
        this.jvmArgs.addAll(jvmArgs);
        this.args.addAll(args);
        if (StringUtils.isNotEmpty((String)classpath)) {
            this.jvmArgs.add("-classpath");
            this.jvmArgs.add(classpath);
        }
        if (propagateSystemProperties) {
            for (Map.Entry<Object, Object> systemProp : System.getProperties().entrySet()) {
                String name = systemProp.getKey().toString();
                String value = systemProp.getValue().toString();
                if (!this.isPropagatableProperty(name)) continue;
                this.jvmArgs.add("-D" + name + "=" + StringUtils.escape((String)value));
            }
        }
    }

    public void run() throws Exception {
        List<String> command = this.buildCommand();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        CommandLine cl = new CommandLine(this.javaExecutable);
        for (String arg : command) {
            cl.addArgument(arg, false);
        }
        int exitValue = exec.execute(cl);
        if (exitValue != 0) {
            throw new MojoFailureException("command line returned non-zero value:" + exitValue);
        }
    }

    private List<String> buildCommand() throws IOException {
        ArrayList<String> command = new ArrayList<String>(2 + this.jvmArgs.size() + this.args.size());
        command.addAll(this.jvmArgs);
        command.add(MainWithArgsInFile.class.getName());
        command.add(this.mainClassName);
        command.add(this.createArgFile(this.args).getCanonicalPath());
        return command;
    }

    private boolean isPropagatableProperty(String name) {
        return !name.startsWith("java.") && !name.startsWith("sun.") && !name.startsWith("maven.") && !name.startsWith("file.") && !name.startsWith("awt.") && !name.startsWith("os.") && !name.startsWith("user.") && !name.equals("line.separator") && !name.equals("path.separator");
    }

    private String findJavaExecutable(Toolchain toolchain) {
        String fromToolchain;
        String string = fromToolchain = toolchain != null ? toolchain.findTool("java") : null;
        if (fromToolchain != null) {
            return fromToolchain;
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null && (javaHome = System.getenv("JAVA_HOME")) == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        return javaHome + File.separator + "bin" + File.separator + "java";
    }

    private File createArgFile(List<String> args) throws IOException {
        File argFile = File.createTempFile(ARG_FILE_PREFIX, ARG_FILE_SUFFIX);
        argFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(argFile);){
            for (String arg : args) {
                out.println(this.escapeArgumentForScalacArgumentFile(arg));
            }
            File file = argFile;
            return file;
        }
    }

    private String escapeArgumentForScalacArgumentFile(String arg) {
        return arg.matches(".*\\s.*") ? '\"' + arg + '\"' : arg;
    }
}

