/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingMojo;
import io.gatling.mojo.AssertionsSummary;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY)
public class VerifyMojo
extends AbstractGatlingMojo {
    @Parameter(property="gatling.resultsFolder", defaultValue="${project.build.directory}/gatling")
    private File resultsFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] runDirectories = this.resultsFolder.listFiles(File::isDirectory);
        if (runDirectories != null) {
            for (File runDirectory : runDirectories) {
                this.searchForAssertionFailures(runDirectory);
            }
        }
    }

    private void searchForAssertionFailures(File runDirectory) throws MojoExecutionException, MojoFailureException {
        File assertionFile;
        File jsDir = new File(runDirectory, "js");
        if (jsDir.exists() && jsDir.isDirectory() && (assertionFile = new File(jsDir, "assertions.xml")).exists()) {
            this.analyzeFile(assertionFile);
        }
    }

    private void analyzeFile(File assertionFile) throws MojoExecutionException, MojoFailureException {
        AssertionsSummary summary;
        try {
            summary = AssertionsSummary.fromAssertionsFile(assertionFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse " + assertionFile.toString(), e);
        }
        if (summary.hasFailures()) {
            throw new MojoFailureException("Gatling simulation assertions failed!");
        }
    }
}

