/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.request;

import io.github.biezhi.request.CloseOperation;
import io.github.biezhi.request.ConnectionFactory;
import io.github.biezhi.request.Const;
import io.github.biezhi.request.FlushOperation;
import io.github.biezhi.request.RequestException;
import io.github.biezhi.request.RequestOutputStream;
import io.github.biezhi.request.UploadProgress;
import io.github.biezhi.request.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class Request {
    private static SSLSocketFactory TRUSTED_FACTORY;
    private static HostnameVerifier TRUSTED_VERIFIER;
    private static ConnectionFactory CONNECTION_FACTORY;
    private HttpURLConnection connection = null;
    private final URL url;
    private final String requestMethod;
    private RequestOutputStream output;
    private boolean multipart;
    private boolean form;
    private boolean ignoreCloseExceptions = true;
    private boolean unCompress = false;
    private int bufferSize = 8192;
    private long totalSize = -1L;
    private long totalWritten = 0L;
    private Proxy proxy;
    private UploadProgress progress = UploadProgress.DEFAULT;

    private static String getValidCharset(String charset) {
        if (charset != null && charset.length() > 0) {
            return charset;
        }
        return "UTF-8";
    }

    private static SSLSocketFactory getTrustedFactory() throws RequestException {
        if (TRUSTED_FACTORY == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            }};
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, trustAllCerts, new SecureRandom());
                TRUSTED_FACTORY = context.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                IOException ioException = new IOException("Security exception configuring SSL context");
                ioException.initCause(e);
                throw new RequestException(ioException);
            }
        }
        return TRUSTED_FACTORY;
    }

    private static HostnameVerifier getTrustedVerifier() {
        if (TRUSTED_VERIFIER == null) {
            TRUSTED_VERIFIER = (hostname, session) -> true;
        }
        return TRUSTED_VERIFIER;
    }

    public static void setConnectionFactory(ConnectionFactory connectionFactory) {
        CONNECTION_FACTORY = connectionFactory == null ? ConnectionFactory.DEFAULT : connectionFactory;
    }

    public static Request get(CharSequence url) throws RequestException {
        return new Request(url, "GET");
    }

    public static Request get(URL url) throws RequestException {
        return new Request(url, "GET");
    }

    public static Request get(CharSequence baseUrl, Map<?, ?> params, boolean encode) {
        String url = Utils.append(baseUrl, params);
        return Request.get(encode ? Utils.encode(url) : url);
    }

    public static Request get(CharSequence baseUrl, boolean encode, Object ... params) {
        String url = Utils.append(baseUrl, params);
        return Request.get(encode ? Utils.encode(url) : url);
    }

    public static Request post(CharSequence url) throws RequestException {
        return new Request(url, "POST");
    }

    public static Request post(URL url) throws RequestException {
        return new Request(url, "POST");
    }

    public static Request post(CharSequence baseUrl, Map<?, ?> params, boolean encode) {
        String url = Utils.append(baseUrl, params);
        return Request.post(encode ? Utils.encode(url) : url);
    }

    public static Request post(CharSequence baseUrl, boolean encode, Object ... params) {
        String url = Utils.append(baseUrl, params);
        return Request.post(encode ? Utils.encode(url) : url);
    }

    public static Request put(CharSequence url) throws RequestException {
        return new Request(url, "PUT");
    }

    public static Request put(URL url) throws RequestException {
        return new Request(url, "PUT");
    }

    public static Request put(CharSequence baseUrl, Map<?, ?> params, boolean encode) {
        String url = Utils.append(baseUrl, params);
        return Request.put(encode ? Utils.encode(url) : url);
    }

    public static Request put(CharSequence baseUrl, boolean encode, Object ... params) {
        String url = Utils.append(baseUrl, params);
        return Request.put(encode ? Utils.encode(url) : url);
    }

    public static Request delete(CharSequence url) throws RequestException {
        return new Request(url, "DELETE");
    }

    public static Request delete(URL url) throws RequestException {
        return new Request(url, "DELETE");
    }

    public static Request delete(CharSequence baseUrl, Map<?, ?> params, boolean encode) {
        String url = Utils.append(baseUrl, params);
        return Request.delete(encode ? Utils.encode(url) : url);
    }

    public static Request delete(CharSequence baseUrl, boolean encode, Object ... params) {
        String url = Utils.append(baseUrl, params);
        return Request.delete(encode ? Utils.encode(url) : url);
    }

    public static Request head(CharSequence url) throws RequestException {
        return new Request(url, "HEAD");
    }

    public static Request head(URL url) throws RequestException {
        return new Request(url, "HEAD");
    }

    public static Request head(CharSequence baseUrl, Map<?, ?> params, boolean encode) {
        String url = Utils.append(baseUrl, params);
        return Request.head(encode ? Utils.encode(url) : url);
    }

    public static Request head(CharSequence baseUrl, boolean encode, Object ... params) {
        String url = Utils.append(baseUrl, params);
        return Request.head(encode ? Utils.encode(url) : url);
    }

    public static Request options(CharSequence url) throws RequestException {
        return new Request(url, "OPTIONS");
    }

    public static Request options(URL url) throws RequestException {
        return new Request(url, "OPTIONS");
    }

    public static Request trace(CharSequence url) throws RequestException {
        return new Request(url, "TRACE");
    }

    public static Request trace(URL url) throws RequestException {
        return new Request(url, "TRACE");
    }

    public static void keepAlive(boolean keepAlive) {
        Request.setProperty("http.keepAlive", Boolean.toString(keepAlive));
    }

    public static void maxConnections(int maxConnections) {
        Request.setProperty("http.maxConnections", Integer.toString(maxConnections));
    }

    public static void proxyHost(String host) {
        Request.setProperty("http.proxyHost", host);
        Request.setProperty("https.proxyHost", host);
    }

    public static void proxyPort(int port) {
        String portValue = Integer.toString(port);
        Request.setProperty("http.proxyPort", portValue);
        Request.setProperty("https.proxyPort", portValue);
    }

    public static void nonProxyHosts(String ... hosts) {
        if (hosts != null && hosts.length > 0) {
            StringBuilder separated = new StringBuilder();
            int last = hosts.length - 1;
            for (int i = 0; i < last; ++i) {
                separated.append(hosts[i]).append('|');
            }
            separated.append(hosts[last]);
            Request.setProperty("http.nonProxyHosts", separated.toString());
        } else {
            Request.setProperty("http.nonProxyHosts", null);
        }
    }

    private static String setProperty(String name, String value) {
        PrivilegedAction<String> action = value != null ? () -> System.setProperty(name, value) : () -> System.clearProperty(name);
        return AccessController.doPrivileged(action);
    }

    public Request(CharSequence url, String method) throws RequestException {
        try {
            this.url = new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RequestException(e);
        }
        this.requestMethod = method;
    }

    public Request(URL url, String method) throws RequestException {
        this.url = url;
        this.requestMethod = method;
    }

    private HttpURLConnection createConnection() {
        try {
            HttpURLConnection connection = this.proxy != null ? CONNECTION_FACTORY.create(this.url, this.proxy) : CONNECTION_FACTORY.create(this.url);
            connection.setRequestMethod(this.requestMethod);
            return connection;
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public String toString() {
        return this.method() + ' ' + this.url();
    }

    public HttpURLConnection getConnection() {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        return this.connection;
    }

    public Request ignoreCloseExceptions(boolean ignore) {
        this.ignoreCloseExceptions = ignore;
        return this;
    }

    public boolean ignoreCloseExceptions() {
        return this.ignoreCloseExceptions;
    }

    public int code() throws RequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseCode();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public Request code(AtomicInteger output) throws RequestException {
        output.set(this.code());
        return this;
    }

    public boolean ok() throws RequestException {
        return 200 == this.code();
    }

    public boolean created() throws RequestException {
        return 201 == this.code();
    }

    public boolean noContent() throws RequestException {
        return 204 == this.code();
    }

    public boolean serverError() throws RequestException {
        return 500 == this.code();
    }

    public boolean badRequest() throws RequestException {
        return 400 == this.code();
    }

    public boolean notFound() throws RequestException {
        return 404 == this.code();
    }

    public boolean notModified() throws RequestException {
        return 304 == this.code();
    }

    public String message() throws RequestException {
        try {
            this.closeOutput();
            return this.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public Request disconnect() {
        this.getConnection().disconnect();
        return this;
    }

    public Request chunk(int size) {
        this.getConnection().setChunkedStreamingMode(size);
        return this;
    }

    public Request bufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be greater than zero");
        }
        this.bufferSize = size;
        return this;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Request uncompress(boolean uncompress) {
        this.unCompress = uncompress;
        return this;
    }

    protected ByteArrayOutputStream byteStream() {
        int size = this.contentLength();
        if (size > 0) {
            return new ByteArrayOutputStream(size);
        }
        return new ByteArrayOutputStream();
    }

    public String body(String charset) throws RequestException {
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.buffer(), output);
            return output.toString(Request.getValidCharset(charset));
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public String body() throws RequestException {
        return this.body(this.charset());
    }

    public boolean isBodyEmpty() throws RequestException {
        return this.contentLength() == 0;
    }

    public byte[] bytes() throws RequestException {
        ByteArrayOutputStream output = this.byteStream();
        try {
            this.copy(this.buffer(), output);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return output.toByteArray();
    }

    public BufferedInputStream buffer() throws RequestException {
        return new BufferedInputStream(this.stream(), this.bufferSize);
    }

    public InputStream stream() throws RequestException {
        InputStream stream;
        if (this.code() < 400) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException e) {
                throw new RequestException(e);
            }
        }
        stream = this.getConnection().getErrorStream();
        if (stream == null) {
            try {
                stream = this.getConnection().getInputStream();
            }
            catch (IOException e) {
                if (this.contentLength() > 0) {
                    throw new RequestException(e);
                }
                stream = new ByteArrayInputStream(new byte[0]);
            }
        }
        if (!this.unCompress || !"gzip".equals(this.contentEncoding())) {
            return stream;
        }
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public InputStreamReader reader(String charset) throws RequestException {
        try {
            return new InputStreamReader(this.stream(), Request.getValidCharset(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestException(e);
        }
    }

    public InputStreamReader reader() throws RequestException {
        return this.reader(this.charset());
    }

    public BufferedReader bufferedReader(String charset) throws RequestException {
        return new BufferedReader(this.reader(charset), this.bufferSize);
    }

    public BufferedReader bufferedReader() throws RequestException {
        return this.bufferedReader(this.charset());
    }

    public Request receive(File file) throws RequestException {
        BufferedOutputStream output;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        }
        catch (FileNotFoundException e) {
            throw new RequestException(e);
        }
        return (Request)new CloseOperation<Request>((Closeable)output, this.ignoreCloseExceptions){

            @Override
            protected Request run() throws RequestException, IOException {
                return Request.this.receive(output);
            }
        }.call();
    }

    public Request receive(OutputStream output) throws RequestException {
        try {
            return this.copy(this.buffer(), output);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public Request receive(PrintStream output) throws RequestException {
        return this.receive((OutputStream)output);
    }

    public Request receive(final Writer writer) throws RequestException {
        final BufferedReader reader = this.bufferedReader();
        return (Request)new CloseOperation<Request>((Closeable)reader, this.ignoreCloseExceptions){

            @Override
            public Request run() throws IOException {
                return Request.this.copy(reader, writer);
            }
        }.call();
    }

    public Request readTimeout(int timeout) {
        this.getConnection().setReadTimeout(timeout);
        return this;
    }

    public Request connectTimeout(int timeout) {
        this.getConnection().setConnectTimeout(timeout);
        return this;
    }

    public Request header(String name, String value) {
        this.getConnection().setRequestProperty(name, value);
        return this;
    }

    public Request header(String name, Number value) {
        return this.header(name, value != null ? value.toString() : null);
    }

    public Request headers(Map<String, String> headers) {
        if (!headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.header(header);
            }
        }
        return this;
    }

    public Request header(Map.Entry<String, String> header) {
        return this.header(header.getKey(), header.getValue());
    }

    public String header(String name) throws RequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderField(name);
    }

    public Map<String, List<String>> headers() throws RequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFields();
    }

    public long dateHeader(String name) throws RequestException {
        return this.dateHeader(name, -1L);
    }

    public long dateHeader(String name, long defaultValue) throws RequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldDate(name, defaultValue);
    }

    public int intHeader(String name) throws RequestException {
        return this.intHeader(name, -1);
    }

    public int intHeader(String name, int defaultValue) throws RequestException {
        this.closeOutputQuietly();
        return this.getConnection().getHeaderFieldInt(name, defaultValue);
    }

    public String[] headers(String name) {
        Map<String, List<String>> headers = this.headers();
        if (headers == null || headers.isEmpty()) {
            return Const.EMPTY_STRINGS;
        }
        List<String> values = headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.toArray(new String[values.size()]);
        }
        return Const.EMPTY_STRINGS;
    }

    public String parameter(String headerName, String paramName) {
        return this.getParam(this.header(headerName), paramName);
    }

    public Map<String, String> parameters(String headerName) {
        return this.getParams(this.header(headerName));
    }

    protected Map<String, String> getParams(String header) {
        if (header == null || header.length() == 0) {
            return Collections.emptyMap();
        }
        int headerLength = header.length();
        int start = header.indexOf(59) + 1;
        if (start == 0 || start == headerLength) {
            return Collections.emptyMap();
        }
        int end = header.indexOf(59, start);
        if (end == -1) {
            end = headerLength;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        while (start < end) {
            String value;
            int length;
            String name;
            int nameEnd = header.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && (name = header.substring(start, nameEnd).trim()).length() > 0 && (length = (value = header.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (length > 2 && '\"' == value.charAt(0) && '\"' == value.charAt(length - 1)) {
                    params.put(name, value.substring(1, length - 1));
                } else {
                    params.put(name, value);
                }
            }
            if ((end = header.indexOf(59, start = end + 1)) != -1) continue;
            end = headerLength;
        }
        return params;
    }

    private String getParam(String value, String paramName) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int length = value.length();
        int start = value.indexOf(59) + 1;
        if (start == 0 || start == length) {
            return null;
        }
        int end = value.indexOf(59, start);
        if (end == -1) {
            end = length;
        }
        while (start < end) {
            String paramValue;
            int valueLength;
            int nameEnd = value.indexOf(61, start);
            if (nameEnd != -1 && nameEnd < end && paramName.equals(value.substring(start, nameEnd).trim()) && (valueLength = (paramValue = value.substring(nameEnd + 1, end).trim()).length()) != 0) {
                if (valueLength > 2 && '\"' == paramValue.charAt(0) && '\"' == paramValue.charAt(valueLength - 1)) {
                    return paramValue.substring(1, valueLength - 1);
                }
                return paramValue;
            }
            start = end + 1;
            if ((end = value.indexOf(59, start)) != -1) continue;
            end = length;
        }
        return null;
    }

    public String charset() {
        return this.parameter("Content-Type", "charset");
    }

    public Request userAgent(String userAgent) {
        return this.header("User-Agent", userAgent);
    }

    public Request referer(String referer) {
        return this.header("Referer", referer);
    }

    public Request useCaches(boolean useCaches) {
        this.getConnection().setUseCaches(useCaches);
        return this;
    }

    public Request acceptEncoding(String acceptEncoding) {
        return this.header("Accept-Encoding", acceptEncoding);
    }

    public Request acceptGzipEncoding() {
        return this.acceptEncoding("gzip");
    }

    public Request acceptCharset(String acceptCharset) {
        return this.header("Accept-Charset", acceptCharset);
    }

    public String contentEncoding() {
        return this.header("Content-Encoding");
    }

    public String server() {
        return this.header("Server");
    }

    public long date() {
        return this.dateHeader("Date");
    }

    public String cacheControl() {
        return this.header("Cache-Control");
    }

    public String eTag() {
        return this.header("ETag");
    }

    public long expires() {
        return this.dateHeader("Expires");
    }

    public long lastModified() {
        return this.dateHeader("Last-Modified");
    }

    public String location() {
        return this.header("Location");
    }

    public Request authorization(String authorization) {
        return this.header("Authorization", authorization);
    }

    public Request proxyAuthorization(String proxyAuthorization) {
        return this.header("Proxy-Authorization", proxyAuthorization);
    }

    public Request basic(String name, String password) {
        return this.authorization("Basic " + Base64.getEncoder().encodeToString((name + ':' + password).getBytes()));
    }

    public Request proxyBasic(String name, String password) {
        return this.proxyAuthorization("Basic " + Base64.getEncoder().encodeToString((name + ':' + password).getBytes()));
    }

    public Request ifModifiedSince(long ifModifiedSince) {
        this.getConnection().setIfModifiedSince(ifModifiedSince);
        return this;
    }

    public Request ifNoneMatch(String ifNoneMatch) {
        return this.header("If-None-Match", ifNoneMatch);
    }

    public Request contentType(String contentType) {
        return this.contentType(contentType, null);
    }

    public Request contentType(String contentType, String charset) {
        if (charset != null && charset.length() > 0) {
            String separator = "; charset=";
            return this.header("Content-Type", contentType + "; charset=" + charset);
        }
        return this.header("Content-Type", contentType);
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public int contentLength() {
        return this.intHeader("Content-Length");
    }

    public Request contentLength(String contentLength) {
        return this.contentLength(Integer.parseInt(contentLength));
    }

    public Request contentLength(int contentLength) {
        this.getConnection().setFixedLengthStreamingMode(contentLength);
        return this;
    }

    public Request accept(String accept) {
        return this.header("Accept", accept);
    }

    public Request acceptJson() {
        return this.accept("application/json");
    }

    protected Request copy(final InputStream input, final OutputStream output) throws IOException {
        return (Request)new CloseOperation<Request>((Closeable)input, this.ignoreCloseExceptions){

            @Override
            public Request run() throws IOException {
                int read;
                byte[] buffer = new byte[Request.this.bufferSize];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                    Request.this.totalWritten = Request.this.totalWritten + (long)read;
                    Request.this.progress.onUpload(Request.this.totalWritten, Request.this.totalSize);
                }
                return Request.this;
            }
        }.call();
    }

    protected Request copy(final Reader input, final Writer output) throws IOException {
        return (Request)new CloseOperation<Request>((Closeable)input, this.ignoreCloseExceptions){

            @Override
            public Request run() throws IOException {
                int read;
                char[] buffer = new char[Request.this.bufferSize];
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                    Request.this.totalWritten = Request.this.totalWritten + (long)read;
                    Request.this.progress.onUpload(Request.this.totalWritten, -1L);
                }
                return Request.this;
            }
        }.call();
    }

    public Request progress(UploadProgress callback) {
        this.progress = callback == null ? UploadProgress.DEFAULT : callback;
        return this;
    }

    private Request incrementTotalSize(long size) {
        if (this.totalSize == -1L) {
            this.totalSize = 0L;
        }
        this.totalSize += size;
        return this;
    }

    protected Request closeOutput() throws IOException {
        this.progress(null);
        if (this.output == null) {
            return this;
        }
        if (this.multipart) {
            this.output.write("\r\n--00content0boundary00--\r\n");
        }
        if (this.ignoreCloseExceptions) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
        } else {
            this.output.close();
        }
        this.output = null;
        return this;
    }

    protected Request closeOutputQuietly() throws RequestException {
        try {
            return this.closeOutput();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    protected Request openOutput() throws IOException {
        if (this.output != null) {
            return this;
        }
        this.getConnection().setDoOutput(true);
        String charset = this.getParam(this.getConnection().getRequestProperty("Content-Type"), "charset");
        this.output = new RequestOutputStream(this.getConnection().getOutputStream(), charset, this.bufferSize);
        return this;
    }

    protected Request startPart() throws IOException {
        if (!this.multipart) {
            this.multipart = true;
            this.contentType("multipart/form-data; boundary=00content0boundary00").openOutput();
            this.output.write("--00content0boundary00\r\n");
        } else {
            this.output.write("\r\n--00content0boundary00\r\n");
        }
        return this;
    }

    protected Request writePartHeader(String name, String filename) throws IOException {
        return this.writePartHeader(name, filename, null);
    }

    protected Request writePartHeader(String name, String filename, String contentType) throws IOException {
        StringBuilder partBuffer = new StringBuilder();
        partBuffer.append("form-data; name=\"").append(name);
        if (filename != null) {
            partBuffer.append("\"; filename=\"").append(filename);
        }
        partBuffer.append('\"');
        this.partHeader("Content-Disposition", partBuffer.toString());
        if (contentType != null) {
            this.partHeader("Content-Type", contentType);
        }
        return this.send("\r\n");
    }

    public Request part(String name, String part) {
        return this.part(name, null, part);
    }

    public Request part(String name, String filename, String part) throws RequestException {
        return this.part(name, filename, null, part);
    }

    public Request part(String name, String filename, String contentType, String part) throws RequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename, contentType);
            this.output.write(part);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this;
    }

    public Request part(String name, Number part) throws RequestException {
        return this.part(name, null, part);
    }

    public Request part(String name, String filename, Number part) throws RequestException {
        return this.part(name, filename, part != null ? part.toString() : null);
    }

    public Request part(String name, File part) throws RequestException {
        return this.part(name, null, part);
    }

    public Request part(String name, String filename, File part) throws RequestException {
        return this.part(name, filename, null, part);
    }

    public Request part(String name, String filename, String contentType, File part) throws RequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(part));
            this.incrementTotalSize(part.length());
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this.part(name, filename, contentType, stream);
    }

    public Request part(String name, InputStream part) throws RequestException {
        return this.part(name, null, null, part);
    }

    public Request part(String name, String filename, String contentType, InputStream part) throws RequestException {
        try {
            this.startPart();
            this.writePartHeader(name, filename, contentType);
            this.copy(part, this.output);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this;
    }

    public Request partHeader(String name, String value) throws RequestException {
        return this.send(name).send(": ").send(value).send("\r\n");
    }

    public Request send(File input) throws RequestException {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(input));
            this.incrementTotalSize(input.length());
        }
        catch (FileNotFoundException e) {
            throw new RequestException(e);
        }
        return this.send(stream);
    }

    public Request send(byte[] input) throws RequestException {
        if (input != null) {
            this.incrementTotalSize(input.length);
        }
        return this.send(new ByteArrayInputStream(input));
    }

    public Request send(InputStream input) throws RequestException {
        try {
            this.openOutput();
            this.copy(input, this.output);
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this;
    }

    public Request send(final Reader input) throws RequestException {
        try {
            this.openOutput();
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        final OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.output, this.output.getEncoder().charset());
        return (Request)new FlushOperation<Request>((Flushable)writer){

            @Override
            protected Request run() throws IOException {
                return Request.this.copy(input, writer);
            }
        }.call();
    }

    public Request send(CharSequence value) throws RequestException {
        try {
            this.openOutput();
            this.output.write(value.toString());
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this;
    }

    public OutputStreamWriter writer() throws RequestException {
        try {
            this.openOutput();
            return new OutputStreamWriter((OutputStream)this.output, this.output.getEncoder().charset());
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
    }

    public Request form(Map<?, ?> values) throws RequestException {
        return this.form(values, "UTF-8");
    }

    public Request form(Map.Entry<?, ?> entry) throws RequestException {
        return this.form(entry, "UTF-8");
    }

    public Request form(Map.Entry<?, ?> entry, String charset) throws RequestException {
        return this.form(entry.getKey(), entry.getValue(), charset);
    }

    public Request form(Object name, Object value) throws RequestException {
        return this.form(name, value, "UTF-8");
    }

    public Request form(Object name, Object value, String charset) throws RequestException {
        boolean first;
        boolean bl = first = !this.form;
        if (first) {
            this.contentType("application/x-www-form-urlencoded", charset);
            this.form = true;
        }
        charset = Request.getValidCharset(charset);
        try {
            this.openOutput();
            if (!first) {
                this.output.write(38);
            }
            this.output.write(URLEncoder.encode(name.toString(), charset));
            this.output.write(61);
            if (value != null) {
                this.output.write(URLEncoder.encode(value.toString(), charset));
            }
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        return this;
    }

    public Request form(Map<?, ?> values, String charset) throws RequestException {
        if (!values.isEmpty()) {
            for (Map.Entry<?, ?> entry : values.entrySet()) {
                this.form(entry, charset);
            }
        }
        return this;
    }

    public Request trustAllCerts() throws RequestException {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(Request.getTrustedFactory());
        }
        return this;
    }

    public Request trustAllHosts() {
        HttpURLConnection connection = this.getConnection();
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier(Request.getTrustedVerifier());
        }
        return this;
    }

    public URL url() {
        return this.getConnection().getURL();
    }

    public String method() {
        return this.getConnection().getRequestMethod();
    }

    public Request useProxy(String proxyHost, int proxyPort) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        return this;
    }

    public Request useProxy(Proxy proxy) {
        if (this.connection != null) {
            throw new IllegalStateException("The connection has already been created. This method must be called before reading or writing to the request.");
        }
        this.proxy = proxy;
        return this;
    }

    public Request followRedirects(boolean followRedirects) {
        this.getConnection().setInstanceFollowRedirects(followRedirects);
        return this;
    }

    static {
        CONNECTION_FACTORY = ConnectionFactory.DEFAULT;
    }
}

