/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.request;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

class RequestOutputStream
extends BufferedOutputStream {
    private final CharsetEncoder encoder;

    RequestOutputStream(OutputStream stream, String charset, int bufferSize) {
        super(stream, bufferSize);
        this.encoder = Charset.forName(RequestOutputStream.getValidCharset(charset)).newEncoder();
    }

    RequestOutputStream write(String value) throws IOException {
        ByteBuffer bytes = this.encoder.encode(CharBuffer.wrap(value));
        super.write(bytes.array(), 0, bytes.limit());
        return this;
    }

    private static String getValidCharset(String charset) {
        if (charset != null && charset.length() > 0) {
            return charset;
        }
        return "UTF-8";
    }

    CharsetEncoder getEncoder() {
        return this.encoder;
    }
}

