/*
 * Decompiled with CFR 0.152.
 */
package io.github.biezhi.request;

import io.github.biezhi.request.RequestException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils {
    public static byte[] toBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private static List<Object> arrayToList(Object array) {
        ArrayList<Object> result;
        block10: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        if (array instanceof Object[]) {
                                            return Arrays.asList((Object[])array);
                                        }
                                        result = new ArrayList<Object>();
                                        if (!(array instanceof int[])) break block9;
                                        for (int value : (int[])array) {
                                            result.add(value);
                                        }
                                        break block10;
                                    }
                                    if (!(array instanceof boolean[])) break block11;
                                    for (boolean value : (boolean[])array) {
                                        result.add(value);
                                    }
                                    break block10;
                                }
                                if (!(array instanceof long[])) break block12;
                                for (long value : (long[])array) {
                                    result.add(value);
                                }
                                break block10;
                            }
                            if (!(array instanceof float[])) break block13;
                            for (float value : (float[])array) {
                                result.add(Float.valueOf(value));
                            }
                            break block10;
                        }
                        if (!(array instanceof double[])) break block14;
                        for (double value : (double[])array) {
                            result.add(value);
                        }
                        break block10;
                    }
                    if (!(array instanceof short[])) break block15;
                    for (short value : (short[])array) {
                        result.add(value);
                    }
                    break block10;
                }
                if (!(array instanceof byte[])) break block16;
                for (byte value : (byte[])array) {
                    result.add(value);
                }
                break block10;
            }
            if (!(array instanceof char[])) break block10;
            for (char value : (char[])array) {
                result.add(Character.valueOf(value));
            }
        }
        return result;
    }

    public static String encode(CharSequence url) throws RequestException {
        URL parsed;
        try {
            parsed = new URL(url.toString());
        }
        catch (IOException e) {
            throw new RequestException(e);
        }
        String host = parsed.getHost();
        int port = parsed.getPort();
        if (port != -1) {
            host = host + ':' + Integer.toString(port);
        }
        try {
            String encoded = new URI(parsed.getProtocol(), host, parsed.getPath(), parsed.getQuery(), null).toASCIIString();
            int paramsStart = encoded.indexOf(63);
            if (paramsStart > 0 && paramsStart + 1 < encoded.length()) {
                encoded = encoded.substring(0, paramsStart + 1) + encoded.substring(paramsStart + 1).replace("+", "%2B");
            }
            return encoded;
        }
        catch (URISyntaxException e) {
            IOException io = new IOException("Parsing URI failed");
            io.initCause(e);
            throw new RequestException(io);
        }
    }

    public static String append(CharSequence url, Map<?, ?> params) {
        String baseUrl = url.toString();
        if (params == null || params.isEmpty()) {
            return baseUrl;
        }
        StringBuilder result = new StringBuilder(baseUrl);
        Utils.addPathSeparator(baseUrl, result);
        Utils.addParamPrefix(baseUrl, result);
        Iterator<Map.Entry<?, ?>> iterator = params.entrySet().iterator();
        Map.Entry<?, ?> entry = iterator.next();
        Utils.addParam(entry.getKey().toString(), entry.getValue(), result);
        while (iterator.hasNext()) {
            result.append('&');
            entry = iterator.next();
            Utils.addParam(entry.getKey().toString(), entry.getValue(), result);
        }
        return result.toString();
    }

    public static String append(CharSequence url, Object ... params) {
        String baseUrl = url.toString();
        if (params == null || params.length == 0) {
            return baseUrl;
        }
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify an even number of parameter names/values");
        }
        StringBuilder result = new StringBuilder(baseUrl);
        Utils.addPathSeparator(baseUrl, result);
        Utils.addParamPrefix(baseUrl, result);
        Utils.addParam(params[0], params[1], result);
        for (int i = 2; i < params.length; i += 2) {
            result.append('&');
            Utils.addParam(params[i], params[i + 1], result);
        }
        return result.toString();
    }

    private static StringBuilder addPathSeparator(String baseUrl, StringBuilder result) {
        if (baseUrl.indexOf(58) + 2 == baseUrl.lastIndexOf(47)) {
            result.append('/');
        }
        return result;
    }

    private static StringBuilder addParamPrefix(String baseUrl, StringBuilder result) {
        int queryStart = baseUrl.indexOf(63);
        int lastChar = result.length() - 1;
        if (queryStart == -1) {
            result.append('?');
        } else if (queryStart < lastChar && baseUrl.charAt(lastChar) != '&') {
            result.append('&');
        }
        return result;
    }

    private static StringBuilder addParam(Object key, Object value, StringBuilder result) {
        if (value != null && value.getClass().isArray()) {
            value = Utils.arrayToList(value);
        }
        if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            while (iterator.hasNext()) {
                result.append(key);
                result.append("[]=");
                Object element = iterator.next();
                if (element != null) {
                    result.append(element);
                }
                if (!iterator.hasNext()) continue;
                result.append("&");
            }
        } else {
            result.append(key);
            result.append("=");
            if (value != null) {
                result.append(value);
            }
        }
        return result;
    }
}

