/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.bmp;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class BmpMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Bmp;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.BMP;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof BmpHeaderDirectory)) continue;
            Integer width = directory.getInteger(2);
            Integer height = directory.getInteger(1);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

