/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.eps;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.eps.EpsDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class EpsMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Eps;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.EPS;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof EpsDirectory)) continue;
            Integer width = directory.getInteger(28);
            Integer height = directory.getInteger(29);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

