/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ddr.poi.html.util.CSSLengthUnit;

public class CSSLength {
    private static final Pattern LENGTH_PATTERN = Pattern.compile("(-?\\d+\\.?\\d*)(" + Arrays.stream(CSSLengthUnit.values()).filter(CSSLengthUnit::isSystem).map(CSSLengthUnit::getLiteral).collect(Collectors.joining("|")) + ")");
    public static final CSSLength INVALID = new CSSLength(Double.NaN, null);
    private double value;
    private CSSLengthUnit unit;

    public CSSLength(double value, CSSLengthUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public CSSLengthUnit getUnit() {
        return this.unit;
    }

    public String toString() {
        return String.format("%.2f", this.value) + (this.unit == null ? "" : this.unit.getLiteral());
    }

    public int toEMU() {
        this.validate();
        this.requireAbsoluteUnit();
        return (int)Math.rint(this.unitValue());
    }

    public double unitValue() {
        return this.value * this.unit.absoluteFactor();
    }

    private void requireAbsoluteUnit() {
        if (this.unit.isRelative()) {
            throw new UnsupportedOperationException("Can not convert a relative length to EMU: " + this.toString());
        }
    }

    private void validate() {
        if (!this.isValid()) {
            throw new UnsupportedOperationException("Invalid CSS length");
        }
    }

    public CSSLength to(CSSLengthUnit other) {
        this.validate();
        return new CSSLength(this.value * this.unit.to(other), other);
    }

    public int toHalfPoints() {
        this.validate();
        return (int)Math.rint(this.value * this.unit.to(CSSLengthUnit.PT) * 2.0);
    }

    public boolean isValid() {
        return this.unit != null && !Double.isNaN(this.value) && !Double.isInfinite(this.value);
    }

    public boolean isPercent() {
        return this.unit == CSSLengthUnit.PERCENT;
    }

    public boolean isValidPercent() {
        return this.isValid() && this.isPercent();
    }

    public static CSSLength of(String text) {
        if (text == null || text.isEmpty()) {
            return INVALID;
        }
        Matcher matcher = LENGTH_PATTERN.matcher(text);
        if (matcher.matches()) {
            return new CSSLength(Double.parseDouble(matcher.group(1)), CSSLengthUnit.of(matcher.group(2)));
        }
        return INVALID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSSLength other = (CSSLength)o;
        if (!this.isValid() && !other.isValid()) {
            return true;
        }
        return Double.compare(other.value, this.value) == 0 && this.unit == other.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit});
    }
}

