/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.gif;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.gif.GifHeaderDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class GifMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Gif;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.GIF;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof GifHeaderDirectory)) continue;
            Integer width = directory.getInteger(2);
            Integer height = directory.getInteger(3);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

