/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.RenderUtils;
import org.ddr.poi.util.XmlUtils;
import org.jsoup.nodes.Element;

public class TableCellRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"th", "td"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        CSSStyleDeclarationImpl styleDeclaration = context.currentElementStyle();
        int row = NumberUtils.toInt((String)element.attr("_r"));
        int column = NumberUtils.toInt((String)element.attr("_c"));
        XWPFTable table = context.getClosestTable();
        XWPFTableCell cell = table.getRow(row).getCell(column);
        context.pushContainer((IBody)cell);
        XWPFParagraph paragraph = cell.getParagraphArray(0);
        XmlCursor newCursor = paragraph.getCTP().newCursor();
        context.pushCursor(newCursor);
        newCursor.dispose();
        RenderUtils.cellStyle(context, cell, styleDeclaration);
        return true;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        List paragraphs = context.getContainer().getParagraphs();
        if (paragraphs.size() > 1) {
            XmlCursor xmlCursor = context.currentCursorObject().newCursor();
            if (xmlCursor.toPrevSibling() && XmlUtils.P_QNAME.equals(xmlCursor.getName())) {
                ((XWPFTableCell)context.getContainer()).removeParagraph(paragraphs.size() - 1);
            }
            xmlCursor.dispose();
        }
        context.popContainer();
        context.popCursor();
        context.unmarkDedupe();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

