/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.math;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.ddr.poi.util.XmlUtils;
import org.openxmlformats.schemas.officeDocument.x2006.math.CTOMath;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MathMLUtils {
    private static final Logger log = LoggerFactory.getLogger(MathMLUtils.class);
    private static final String MATH_FONT = "Cambria Math";
    private static final QName OMATH_QNAME = new QName("http://schemas.openxmlformats.org/officeDocument/2006/math", "oMath");
    private static final Pattern ESCAPED = Pattern.compile("&[a-zA-Z]+;");
    private static final Set<String> PREDEFINED = new HashSet<String>(Arrays.asList("&amp;", "&lt;", "&gt;", "&quot;", "&apos;"));

    public static void renderTo(XWPFParagraph paragraph, CTR ctr, String math) {
        if (log.isDebugEnabled()) {
            log.info("Start rendering MathML: {}", (Object)math);
        }
        try (StringReader sr = new StringReader(math);
             StringWriter sw = new StringWriter();){
            Serializer out = MathMLUtils.newSerializer(sw);
            Initializer.TRANSFORMER.transform((Source)new StreamSource(sr), (Destination)out);
            String omath = sw.toString();
            if (log.isDebugEnabled()) {
                log.info("Output OMath: {}", (Object)omath);
            }
            MathMLUtils.addMath(paragraph, ctr, omath);
        }
        catch (IOException | SaxonApiException | XmlException e) {
            log.warn("Failed to render math: {}", (Object)math, (Object)e);
        }
    }

    public static String normalize(String math) {
        Matcher matcher = ESCAPED.matcher(math);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String entity = matcher.group();
            if (PREDEFINED.contains(entity)) continue;
            int codePoint = StringEscapeUtils.unescapeHtml4((String)entity).codePointAt(0);
            matcher.appendReplacement(buffer, "&#" + codePoint + ";");
        }
        matcher.appendTail(buffer);
        math = buffer.toString();
        return math;
    }

    private static Serializer newSerializer(StringWriter sw) {
        Serializer out = Initializer.PROCESSOR.newSerializer((Writer)sw);
        out.setOutputProperty(Serializer.Property.METHOD, "xml");
        out.setOutputProperty(Serializer.Property.INDENT, "no");
        out.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        return out;
    }

    private static void addMath(XWPFParagraph paragraph, CTR ctr, String omath) throws XmlException {
        CTOMath ctoMath = CTOMath.Factory.parse((String)omath);
        XmlCursor xmlCursor = ctoMath.newCursor();
        while (xmlCursor.hasNextToken()) {
            XmlCursor.TokenType tokenType = xmlCursor.toNextToken();
            if (tokenType != XmlCursor.TokenType.START || !XmlUtils.R_QNAME.equals(xmlCursor.getName())) continue;
            CTFonts ctFonts = ((org.openxmlformats.schemas.officeDocument.x2006.math.CTR)xmlCursor.getObject()).addNewRPr2().addNewRFonts();
            ctFonts.setAscii(MATH_FONT);
            ctFonts.setEastAsia(MATH_FONT);
            ctFonts.setHAnsi(MATH_FONT);
            ctFonts.setCs(MATH_FONT);
        }
        xmlCursor.dispose();
        CTP ctp = paragraph.getCTP();
        if (ctr == null) {
            ctp.addNewOMath();
            ctp.setOMathArray(ctp.sizeOfOMathArray() - 1, ctoMath.getOMathArray(0));
            return;
        }
        MathMLUtils.insertMathAfterRun(ctp, ctr, ctoMath);
    }

    private static void insertMathAfterRun(CTP ctp, CTR ctr, CTOMath ctoMath) {
        int oMathIndex = 0;
        boolean foundCTR = false;
        XmlCursor xmlCursor = ctp.newCursor();
        while (xmlCursor.hasNextToken()) {
            XmlCursor.TokenType tokenType = xmlCursor.toNextToken();
            if (tokenType != XmlCursor.TokenType.START) continue;
            if (xmlCursor.getObject() == ctr) {
                foundCTR = true;
                xmlCursor.toEndToken();
                xmlCursor.toNextToken();
                xmlCursor.insertElement(OMATH_QNAME);
                break;
            }
            if (!OMATH_QNAME.equals(xmlCursor.getName())) continue;
            ++oMathIndex;
        }
        xmlCursor.dispose();
        if (!foundCTR) {
            throw new IllegalArgumentException("The run does not belong to the paragraph");
        }
        ctp.setOMathArray(oMathIndex, ctoMath.getOMathArray(0));
    }

    private static class Initializer {
        static final Processor PROCESSOR = new Processor(false);
        static final Xslt30Transformer TRANSFORMER = Initializer.createTransformer();

        private Initializer() {
        }

        private static Xslt30Transformer createTransformer() {
            XsltExecutable stylesheet;
            XsltCompiler compiler = PROCESSOR.newXsltCompiler();
            try (InputStream inputStream = MathMLUtils.class.getResourceAsStream("/MML2OMML.XSL");){
                stylesheet = compiler.compile((Source)new StreamSource(inputStream));
            }
            catch (IOException | SaxonApiException e) {
                throw new IllegalStateException("Failed to load MML2OMML.XSL", e);
            }
            return stylesheet.load30();
        }
    }
}

