/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.JsoupUtils;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FigureRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"figure"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        Elements captions = JsoupUtils.children(element, "figcaption");
        if (captions.size() > 1) {
            captions.remove(0);
            captions.remove();
        }
        XWPFParagraph paragraph = context.getClosestParagraph();
        context.markDedupe(paragraph);
        CSSStyleDeclarationImpl styleDeclaration = context.currentElementStyle();
        String cssFloat = styleDeclaration.getPropertyValue("float");
        if ("left".equals(cssFloat)) {
            paragraph.setAlignment(ParagraphAlignment.LEFT);
            styleDeclaration.setTextAlign("left");
        } else if ("right".equals(cssFloat)) {
            paragraph.setAlignment(ParagraphAlignment.RIGHT);
            styleDeclaration.setTextAlign("right");
        } else {
            paragraph.setAlignment(ParagraphAlignment.CENTER);
            styleDeclaration.setTextAlign("center");
        }
        return true;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        context.unmarkDedupe();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return true;
    }
}

