/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.SVGPictureData;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.util.ByteArrayCopyStream;
import org.ddr.poi.util.HttpURLConnectionUtils;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
implements ElementRenderer {
    private static final Logger log = LoggerFactory.getLogger(ImageRenderer.class);
    private static final String[] TAGS = new String[]{"img"};
    private static final String HTTP = "http";
    private static final String DOUBLE_SLASH = "//";
    private static final String BASE64_PREFIX = "data:";
    private static final Map<String, ImageType> PICTURE_TYPES = new HashMap<String, ImageType>(ImageType.values().length);

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        String src = element.attr("src");
        if (StringUtils.startsWithIgnoreCase((CharSequence)src, (CharSequence)HTTP)) {
            this.handleRemoteImage(element, context, src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)DOUBLE_SLASH)) {
            this.handleRemoteImage(element, context, "http:" + src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)BASE64_PREFIX)) {
            this.handleBase64(element, context, src);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBase64(Element element, HtmlRenderContext context, String src) {
        byte[] bytes;
        int index = src.indexOf(",".charAt(0));
        String data = src.substring(index + 1);
        String format = StringUtils.substringBetween((String)src.substring(0, index), (String)"/", (String)";");
        if (format.contains("-")) {
            format = StringUtils.substringAfterLast((String)format, (String)"-");
        } else if (format.contains("+")) {
            format = StringUtils.substringBefore((String)format, (String)"+");
        }
        try {
            bytes = Base64.getDecoder().decode(data);
        }
        catch (Exception e) {
            log.warn("Failed to load image due to illegal base64 data: {}", (Object)src);
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            BufferedImage image = ImageIO.read(inputStream);
            ((InputStream)inputStream).reset();
            int type = PICTURE_TYPES.getOrDefault(format, this.typeOf(image)).getType();
            boolean svg = "svg".equals(format);
            this.addPicture(element, context, inputStream, type, image.getWidth(), image.getHeight(), (byte[])(svg ? bytes : null));
        }
        catch (IOException | InvalidFormatException e) {
            log.warn("Failed to load image: {}", (Object)src, (Object)e);
        }
        finally {
            Object image = null;
        }
    }

    protected ImageType typeOf(BufferedImage image) {
        return image.getColorModel().hasAlpha() ? ImageType.PNG : ImageType.JPG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRemoteImage(Element element, HtmlRenderContext context, String src) {
        BufferedImage image;
        HttpURLConnection connect;
        InputStream inputStream;
        ByteArrayCopyStream outputStream;
        block11: {
            block10: {
                String extension = FilenameUtils.getExtension((String)StringUtils.substringBefore((String)src, (String)"?")).toLowerCase();
                ImageType type = PICTURE_TYPES.get(extension);
                outputStream = null;
                inputStream = null;
                connect = null;
                try {
                    connect = HttpURLConnectionUtils.connect(src);
                    InputStream urlStream = connect.getInputStream();
                    boolean svg = connect.getHeaderField("content-type").contains("svg");
                    byte[] svgData = null;
                    if (svg) {
                        outputStream = new ByteArrayCopyStream(urlStream.available());
                        IOUtils.copy((InputStream)urlStream, (OutputStream)outputStream);
                        svgData = outputStream.toByteArray();
                        image = ImageIO.read(outputStream.toInput());
                    } else {
                        image = ImageIO.read(urlStream);
                    }
                    if (image == null) {
                        log.warn("Illegal image url: {}", (Object)src);
                        IOUtils.close((URLConnection)connect);
                        break block10;
                    }
                    int size = image.getData().getDataBuffer().getSize();
                    outputStream = new ByteArrayCopyStream(size);
                    if (type == null) {
                        type = this.typeOf(image);
                    }
                    ImageIO.write((RenderedImage)image, type.getExtension(), outputStream);
                    inputStream = outputStream.toInput();
                    this.addPicture(element, context, inputStream, type.getType(), image.getWidth(), image.getHeight(), svgData);
                    IOUtils.close((URLConnection)connect);
                    break block11;
                }
                catch (IOException | InvalidFormatException e) {
                    log.warn("Failed to load image: {}", (Object)src, (Object)e);
                    return;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly(inputStream);
            return;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        return;
        finally {
            IOUtils.close((URLConnection)connect);
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            image = null;
        }
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }

    protected void addPicture(Element element, HtmlRenderContext context, InputStream inputStream, int type, int widthInPixels, int heightInPixels, byte[] svgData) throws InvalidFormatException, IOException {
        int containerWidth = context.getAvailableWidthInEMU();
        int widthInEMU = Units.pixelToEMU((int)widthInPixels);
        int heightInEMU = Units.pixelToEMU((int)heightInPixels);
        boolean declaredWidth = false;
        boolean declaredHeight = false;
        String width = context.getPropertyValue("width");
        if (width.length() > 0) {
            declaredWidth = true;
        } else {
            width = element.attr("width");
            if (NumberUtils.isParsable((String)width)) {
                width = width + "px";
                declaredWidth = true;
            }
        }
        String maxWidth = context.getPropertyValue("max-width");
        widthInEMU = context.computeLengthInEMU(width, maxWidth, widthInEMU, containerWidth);
        String height = context.getPropertyValue("height");
        if (height.length() > 0) {
            declaredHeight = true;
        } else {
            height = element.attr("height");
            if (NumberUtils.isParsable((String)height)) {
                height = height + "px";
                declaredHeight = true;
            }
        }
        String maxHeight = context.getPropertyValue("max-height");
        heightInEMU = context.computeLengthInEMU(height, maxHeight, heightInEMU, Integer.MAX_VALUE);
        if (!declaredHeight) {
            heightInEMU = (int)((long)heightInPixels * (long)widthInEMU / (long)widthInPixels);
        } else if (!declaredWidth && (widthInEMU = (int)((long)widthInPixels * (long)heightInEMU / (long)heightInPixels)) > containerWidth) {
            widthInEMU = containerWidth;
            heightInEMU = (int)((long)heightInPixels * (long)widthInEMU / (long)widthInPixels);
        }
        context.renderPicture(inputStream, type, "img", widthInEMU, heightInEMU, svgData);
    }

    static {
        for (ImageType type : ImageType.values()) {
            PICTURE_TYPES.put(type.getExtension(), type);
        }
        SVGPictureData.initRelation();
    }

    static enum ImageType {
        EMF(2),
        WMF(3),
        PICT(4),
        JPEG(5),
        JPG(5),
        PNG(6),
        DIB(7),
        GIF(8),
        TIF(9),
        TIFF(9),
        EPS(10),
        BMP(11),
        WPG(12);

        private final int type;

        private ImageType(int type) {
            this.type = type;
        }

        public String getExtension() {
            return this.name().toLowerCase();
        }

        public int getType() {
            return this.type;
        }
    }
}

