/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classgraph;

import io.github.lukehutch.fastclasspathscanner.classgraph.AnnotationNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.classgraph.DAGNode;
import io.github.lukehutch.fastclasspathscanner.classgraph.InterfaceNode;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.utils.LazyMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMap;
import io.github.lukehutch.fastclasspathscanner.utils.MultiSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGraphBuilder {
    private final ClassfileBinaryParser classfileBinaryParser = new ClassfileBinaryParser(this);
    private final LazyMap<String, ClassNode> classNameToClassNode = new LazyMap<String, ClassNode>(){

        @Override
        public void initialize() {
            ClassGraphBuilder.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, InterfaceNode> interfaceNameToInterfaceNode = new LazyMap<String, InterfaceNode>(){

        @Override
        public void initialize() {
            ClassGraphBuilder.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, AnnotationNode> annotationNameToAnnotationNode = new LazyMap<String, AnnotationNode>(){

        @Override
        public void initialize() {
            for (AnnotationNode annotationNode : this.map.values()) {
                annotationNode.resolveAnnotationNames(this.map);
            }
            ClassGraphBuilder.findTransitiveClosure(this.map.values());
        }
    };
    private final LazyMap<String, ArrayList<String>> interfaceNameToClassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            ArrayList<DAGNode> classNodeTopoOrder = DAGNode.topoSort(ClassGraphBuilder.this.allClassNodes());
            ArrayList<DAGNode> interfaceNodeTopoOrder = DAGNode.topoSort(ClassGraphBuilder.this.allInterfaceNodes());
            HashMap interfaceNameToClassNodesSet = new HashMap();
            for (DAGNode dAGNode : classNodeTopoOrder) {
                ArrayList<String> interfaceNames = ((ClassNode)dAGNode).interfaceNames;
                if (interfaceNames == null) continue;
                HashSet<String> interfacesAndSuperinterfacesUnion = new HashSet<String>();
                for (String interfaceName : interfaceNames) {
                    interfacesAndSuperinterfacesUnion.add(interfaceName);
                    InterfaceNode interfaceNode = (InterfaceNode)ClassGraphBuilder.this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
                    if (interfaceNode == null) continue;
                    for (DAGNode superinterfaceNode : interfaceNode.allSuperNodes) {
                        interfacesAndSuperinterfacesUnion.add(superinterfaceNode.name);
                    }
                }
                for (String interfaceName : interfacesAndSuperinterfacesUnion) {
                    MultiSet.put(interfaceNameToClassNodesSet, interfaceName, dAGNode);
                }
            }
            for (DAGNode dAGNode : interfaceNodeTopoOrder) {
                HashSet implementingClasses = (HashSet)interfaceNameToClassNodesSet.get(dAGNode.name);
                if (implementingClasses == null) continue;
                HashSet<DAGNode> subClassUnion = new HashSet<DAGNode>();
                for (DAGNode implementingClass : implementingClasses) {
                    subClassUnion.addAll(implementingClass.allSubNodes);
                }
                implementingClasses.addAll(subClassUnion);
            }
            for (Map.Entry entry : interfaceNameToClassNodesSet.entrySet()) {
                HashSet nodes = (HashSet)entry.getValue();
                ArrayList<String> classNameList = new ArrayList<String>(nodes.size());
                for (DAGNode classNode : nodes) {
                    classNameList.add(classNode.name);
                }
                this.map.put(entry.getKey(), classNameList);
            }
        }
    };
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedClassNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (AnnotationNode annotationNode : ClassGraphBuilder.this.allAnnotationNodes()) {
                for (DAGNode subNode : annotationNode.allSubNodes) {
                    MultiSet.putAll(this.map, annotationNode.name, ((AnnotationNode)subNode).annotatedClassNames);
                }
                MultiSet.putAll(this.map, annotationNode.name, annotationNode.annotatedClassNames);
            }
        }
    };
    private final LazyMap<String, HashSet<String>> annotationNameToAnnotatedAnnotationNamesSet = new LazyMap<String, HashSet<String>>(){

        @Override
        public void initialize() {
            for (AnnotationNode annotationNode : ClassGraphBuilder.this.allAnnotationNodes()) {
                for (DAGNode subNode : annotationNode.allSubNodes) {
                    MultiSet.put(this.map, annotationNode.name, subNode.name);
                }
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToAnnotatedClassNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : ClassGraphBuilder.this.annotationNameToAnnotatedClassNamesSet.resolve().entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), (Iterable)ent.getValue());
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> classNameToAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : MultiSet.invert(ClassGraphBuilder.this.annotationNameToAnnotatedClassNamesSet.resolve()).entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), ent.getValue());
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> metaAnnotationNameToAnnotatedAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : ClassGraphBuilder.this.annotationNameToAnnotatedAnnotationNamesSet.resolve().entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), (Iterable)ent.getValue());
            }
        }
    };
    private final LazyMap<String, ArrayList<String>> annotationNameToMetaAnnotationNames = new LazyMap<String, ArrayList<String>>(){

        @Override
        public void initialize() {
            for (Map.Entry ent : MultiSet.invert(ClassGraphBuilder.this.annotationNameToAnnotatedAnnotationNamesSet.resolve()).entrySet()) {
                MultiMap.putAll(this.map, ent.getKey(), ent.getValue());
            }
        }
    };

    private Collection<ClassNode> allClassNodes() {
        return this.classNameToClassNode.resolve().values();
    }

    public Set<String> getNamesOfAllClasses() {
        return this.classNameToClassNode.resolve().keySet();
    }

    private Collection<InterfaceNode> allInterfaceNodes() {
        return this.interfaceNameToInterfaceNode.resolve().values();
    }

    private Collection<AnnotationNode> allAnnotationNodes() {
        return this.annotationNameToAnnotationNode.resolve().values();
    }

    public void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.classfileBinaryParser.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        ClassNode classNode = this.classNameToClassNode.resolve().get(className);
        if (classNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> subclasses = new ArrayList<String>(classNode.allSubNodes.size());
        for (DAGNode subNode : classNode.allSubNodes) {
            subclasses.add(subNode.name);
        }
        return subclasses;
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        ClassNode classNode = this.classNameToClassNode.resolve().get(className);
        if (classNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> superclasses = new ArrayList<String>(classNode.allSuperNodes.size());
        for (DAGNode subNode : classNode.allSuperNodes) {
            superclasses.add(subNode.name);
        }
        return superclasses;
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
        if (interfaceNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> subinterfaces = new ArrayList<String>(interfaceNode.allSubNodes.size());
        for (DAGNode subNode : interfaceNode.allSubNodes) {
            subinterfaces.add(subNode.name);
        }
        return subinterfaces;
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        InterfaceNode interfaceNode = this.interfaceNameToInterfaceNode.resolve().get(interfaceName);
        if (interfaceNode == null) {
            return Collections.emptyList();
        }
        ArrayList<String> superinterfaces = new ArrayList<String>(interfaceNode.allSuperNodes.size());
        for (DAGNode superNode : interfaceNode.allSuperNodes) {
            superinterfaces.add(superNode.name);
        }
        return superinterfaces;
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        ArrayList<String> classes = this.interfaceNameToClassNames.resolve().get(interfaceName);
        if (classes == null) {
            return Collections.emptyList();
        }
        return classes;
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        ArrayList<String> annotationNames = this.classNameToAnnotationNames.resolve().get(classOrInterfaceName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ArrayList<String> metaAnnotationNames = this.annotationNameToMetaAnnotationNames.resolve().get(annotationName);
        if (metaAnnotationNames == null) {
            return Collections.emptyList();
        }
        return metaAnnotationNames;
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ArrayList<String> classNames = this.annotationNameToAnnotatedClassNames.resolve().get(annotationName);
        if (classNames == null) {
            return Collections.emptyList();
        }
        return classNames;
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ArrayList<String> annotationNames = this.metaAnnotationNameToAnnotatedAnnotationNames.resolve().get(metaAnnotationName);
        if (annotationNames == null) {
            return Collections.emptyList();
        }
        return annotationNames;
    }

    void linkClass(String superclassName, ArrayList<String> interfaces, String className) {
        HashMap<String, ClassNode> map = this.classNameToClassNode.getRawMap();
        ClassNode classNode = map.get(className);
        if (classNode == null) {
            classNode = new ClassNode(className, interfaces);
            map.put(className, classNode);
        } else {
            classNode.addInterfaces(interfaces);
        }
        if (superclassName != null) {
            ClassNode superclassNode = map.get(superclassName);
            if (superclassNode == null) {
                superclassNode = new ClassNode(superclassName, classNode);
                map.put(superclassName, superclassNode);
            } else {
                superclassNode.addSubNode(classNode);
            }
        }
    }

    void linkInterface(ArrayList<String> superInterfaceNames, String interfaceName) {
        HashMap<String, InterfaceNode> map = this.interfaceNameToInterfaceNode.getRawMap();
        InterfaceNode interfaceNode = map.get(interfaceName);
        if (interfaceNode == null) {
            interfaceNode = new InterfaceNode(interfaceName);
            map.put(interfaceName, interfaceNode);
        }
        if (superInterfaceNames != null) {
            for (String superInterfaceName : superInterfaceNames) {
                InterfaceNode superInterfaceNode = map.get(superInterfaceName);
                if (superInterfaceNode == null) {
                    superInterfaceNode = new InterfaceNode(superInterfaceName, interfaceNode);
                    map.put(superInterfaceName, superInterfaceNode);
                    continue;
                }
                superInterfaceNode.addSubNode(interfaceNode);
            }
        }
    }

    void linkAnnotation(String annotationName, String annotatedClassName, boolean annotatedClassIsAnnotation) {
        HashMap<String, AnnotationNode> map = this.annotationNameToAnnotationNode.getRawMap();
        AnnotationNode annotationNode = map.get(annotationName);
        if (annotationNode == null) {
            annotationNode = new AnnotationNode(annotationName);
            map.put(annotationName, annotationNode);
        }
        if (annotatedClassIsAnnotation) {
            AnnotationNode annotatedAnnotationNode = map.get(annotatedClassName);
            if (annotatedAnnotationNode == null) {
                annotatedAnnotationNode = new AnnotationNode(annotatedClassName);
                map.put(annotatedClassName, annotatedAnnotationNode);
            }
            annotationNode.addAnnotatedAnnotation(annotatedClassName);
        } else {
            annotationNode.addAnnotatedClass(annotatedClassName);
        }
    }

    private static void findTransitiveClosure(Collection<? extends DAGNode> nodes) {
        HashSet<DAGNode> activeTopDownNodes = new HashSet<DAGNode>();
        for (DAGNode dAGNode : nodes) {
            if (!dAGNode.directSuperNodes.isEmpty()) continue;
            activeTopDownNodes.addAll(dAGNode.directSubNodes);
        }
        while (!activeTopDownNodes.isEmpty()) {
            HashSet<DAGNode> activeTopDownNodesNext = new HashSet<DAGNode>(activeTopDownNodes.size());
            for (DAGNode dAGNode : activeTopDownNodes) {
                boolean changed = dAGNode.allSuperNodes.addAll(dAGNode.directSuperNodes);
                for (DAGNode superNode : dAGNode.directSuperNodes) {
                    changed |= dAGNode.allSuperNodes.addAll(superNode.allSuperNodes);
                }
                if (!changed) continue;
                for (DAGNode subNode : dAGNode.directSubNodes) {
                    activeTopDownNodesNext.add(subNode);
                }
            }
            activeTopDownNodes = activeTopDownNodesNext;
        }
        HashSet<DAGNode> activeBottomUpNodes = new HashSet<DAGNode>();
        for (DAGNode dAGNode : nodes) {
            if (!dAGNode.directSubNodes.isEmpty()) continue;
            activeBottomUpNodes.addAll(dAGNode.directSuperNodes);
        }
        while (!activeBottomUpNodes.isEmpty()) {
            HashSet<DAGNode> hashSet = new HashSet<DAGNode>(activeBottomUpNodes.size());
            for (DAGNode node : activeBottomUpNodes) {
                boolean changed = node.allSubNodes.addAll(node.directSubNodes);
                for (DAGNode subNode : node.directSubNodes) {
                    changed |= node.allSubNodes.addAll(subNode.allSubNodes);
                }
                if (!changed) continue;
                for (DAGNode superNode : node.directSuperNodes) {
                    hashSet.add(superNode);
                }
            }
            activeBottomUpNodes = hashSet;
        }
    }

    public void reset() {
        this.classfileBinaryParser.reset();
        this.classNameToClassNode.clear();
        this.interfaceNameToInterfaceNode.clear();
        this.annotationNameToAnnotationNode.clear();
        this.annotationNameToAnnotatedClassNamesSet.clear();
        this.annotationNameToAnnotatedAnnotationNamesSet.clear();
        this.annotationNameToAnnotatedClassNames.clear();
        this.classNameToAnnotationNames.clear();
        this.metaAnnotationNameToAnnotatedAnnotationNames.clear();
        this.annotationNameToMetaAnnotationNames.clear();
        this.interfaceNameToClassNames.clear();
    }

    public void readClassInfoFromClassfileHeader(InputStream inputStream, boolean verbose) throws IOException {
        this.classfileBinaryParser.readClassInfoFromClassfileHeader(inputStream, verbose);
    }
}

