/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class HashClassfileContents {
    private final FastClasspathScanner scanner;
    private final HashMap<String, String> classNameToClassfileHash = new HashMap();

    public HashClassfileContents(String ... packagePrefixesToScan) {
        this.scanner = new FastClasspathScanner(packagePrefixesToScan).matchFilenameExtension("class", new FileMatchProcessor(){

            @Override
            public void processMatch(String relativePath, InputStream inputStream, int length) throws IOException {
                int read;
                MessageDigest digest;
                try {
                    digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                byte[] buffer = new byte[8192];
                while ((read = inputStream.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                String hash = "0000000000000000000000000000000" + new BigInteger(1, digest.digest()).toString(16);
                String className = relativePath.substring(0, relativePath.length() - 6).replace('/', '.');
                HashClassfileContents.this.classNameToClassfileHash.put(className, hash.substring(hash.length() - 32));
            }
        });
    }

    public HashClassfileContents scan() {
        this.classNameToClassfileHash.clear();
        this.scanner.scan();
        return this;
    }

    public HashMap<String, String> getClassNameToClassfileHash() {
        return this.classNameToClassfileHash;
    }
}

