/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePathToElementMap;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final boolean scanFiles;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final LogNode log;
    private static final int NUM_FILES_PER_CHUNK = 200;

    public Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, boolean enableRecursiveScanning, LogNode log) {
        this.scanSpec = scanSpec;
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.scanFiles = enableRecursiveScanning;
        this.log = log;
    }

    private static void findClasspathOrder(ClasspathElement currSingleton, ClasspathRelativePathToElementMap classpathElementMap, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) throws InterruptedException {
        if (visitedClasspathElts.add(currSingleton)) {
            order.add(currSingleton);
            if (currSingleton.childClasspathElts != null) {
                for (ClasspathRelativePath childClasspathElt : currSingleton.childClasspathElts) {
                    ClasspathElement childSingleton = (ClasspathElement)classpathElementMap.get(childClasspathElt);
                    if (childSingleton == null || childSingleton.ioExceptionOnOpen) continue;
                    Scanner.findClasspathOrder(childSingleton, classpathElementMap, visitedClasspathElts, order);
                }
            }
        }
    }

    private static List<ClasspathElement> findClasspathOrder(List<ClasspathRelativePath> rawClasspathElements, ClasspathRelativePathToElementMap classpathElementMap) throws InterruptedException {
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathRelativePath toplevelClasspathElt : rawClasspathElements) {
            ClasspathElement toplevelSingleton = (ClasspathElement)classpathElementMap.get(toplevelClasspathElt);
            if (toplevelSingleton == null || toplevelSingleton.ioExceptionOnOpen) continue;
            Scanner.findClasspathOrder(toplevelSingleton, classpathElementMap, visitedClasspathElts, order);
        }
        return order;
    }

    private static List<ClassfileParserChunk> getClassfileParserChunks(List<ClasspathElement> classpathOrder) {
        LinkedList chunks = new LinkedList();
        for (ClasspathElement classpathElement : classpathOrder) {
            LinkedList<ClassfileParserChunk> chunksForClasspathElt = new LinkedList<ClassfileParserChunk>();
            int n = classpathElement.getNumClassfileMatches();
            if (n > 0) {
                int numChunks = (int)Math.ceil((float)n / 200.0f);
                float filesPerChunk = (float)n / (float)numChunks;
                for (int i = 0; i < numChunks; ++i) {
                    int classfileEndIdx;
                    int classfileStartIdx = (int)((float)i * filesPerChunk);
                    int n2 = classfileEndIdx = i < numChunks - 1 ? (int)((float)(i + 1) * filesPerChunk) : n;
                    if (classfileEndIdx <= classfileStartIdx) continue;
                    chunksForClasspathElt.add(new ClassfileParserChunk(classpathElement, classfileStartIdx, classfileEndIdx));
                }
            }
            chunks.add(chunksForClasspathElt);
        }
        ArrayList<ClassfileParserChunk> interleavedChunks = new ArrayList<ClassfileParserChunk>();
        while (!chunks.isEmpty()) {
            LinkedList<LinkedList> nextChunks = new LinkedList<LinkedList>();
            for (LinkedList linkedList : chunks) {
                if (linkedList.isEmpty()) continue;
                ClassfileParserChunk head = (ClassfileParserChunk)linkedList.remove();
                interleavedChunks.add(head);
                if (linkedList.isEmpty()) continue;
                nextChunks.add(linkedList);
            }
            chunks = nextChunks;
        }
        return interleavedChunks;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ClassfileParserChunk {
        private final ClasspathElement classpathElement;
        private final int classfileStartIdx;
        private final int classfileEndIdx;

        public ClassfileParserChunk(ClasspathElement classpathElementSingleton, int classfileStartIdx, int classfileEndIdx) {
            this.classpathElement = classpathElementSingleton;
            this.classfileStartIdx = classfileStartIdx;
            this.classfileEndIdx = classfileEndIdx;
        }
    }
}

