/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.utils.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MatchProcessorException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<Exception> exceptions;

    MatchProcessorException(List<Exception> exceptions, Exception e) {
        super(e);
        this.exceptions = exceptions;
    }

    MatchProcessorException(List<Exception> exceptions, String msg) {
        super(msg);
        this.exceptions = exceptions;
    }

    public List<Exception> getExceptions() {
        return this.exceptions == null ? Collections.emptyList() : this.exceptions;
    }

    public static MatchProcessorException newInstance(List<Exception> exceptions) {
        if (exceptions.size() == 1) {
            return new MatchProcessorException(exceptions, exceptions.get(0));
        }
        HashSet<String> exceptionNames = new HashSet<String>();
        for (Exception e : exceptions) {
            exceptionNames.add(e.getMessage());
        }
        ArrayList exceptionNamesSorted = new ArrayList(exceptionNames);
        Collections.sort(exceptionNamesSorted);
        return new MatchProcessorException(exceptions, "Multiple exceptions thrown: " + Join.join(", ", exceptionNamesSorted));
    }
}

