/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ClassLoaderFinder {
    private static CallerResolver CALLER_RESOLVER;

    public static List<ClassLoader> findClassLoaders(ScanSpec scanSpec, LogNode log) {
        List<ClassLoader> classLoadersRaw = scanSpec.overrideClassLoaders;
        LogNode classLoadersFoundLog = null;
        if (classLoadersRaw == null) {
            classLoadersRaw = new ArrayList<ClassLoader>();
            classLoadersRaw.add(ClassLoader.getSystemClassLoader());
            if (CALLER_RESOLVER == null) {
                if (log != null) {
                    log.log(ClassLoaderFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
                }
            } else {
                Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
                if (callStack == null) {
                    if (log != null) {
                        log.log(ClassLoaderFinder.class.getSimpleName() + ": " + CallerResolver.class.getSimpleName() + "#getClassContext() returned null");
                    }
                } else {
                    int fcsIdx;
                    String fcsPkgPrefix = FastClasspathScanner.class.getPackage().getName() + ".";
                    for (fcsIdx = callStack.length - 1; fcsIdx >= 0 && !callStack[fcsIdx].getName().startsWith(fcsPkgPrefix); --fcsIdx) {
                    }
                    if (fcsIdx < 0 || fcsIdx == callStack.length - 1) {
                        throw new RuntimeException("Could not find caller of " + (String)fcsPkgPrefix + "* in call stack");
                    }
                    classLoadersRaw.add(callStack[fcsIdx + 1].getClassLoader());
                }
            }
            classLoadersRaw.add(Thread.currentThread().getContextClassLoader());
            if (scanSpec.addedClassLoaders != null) {
                classLoadersRaw.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        List<ClassLoader> classLoadersWorking = new ArrayList(classLoadersRaw.size());
        for (ClassLoader classLoader : classLoadersRaw) {
            if (classLoader == null) continue;
            classLoadersWorking.add(classLoader);
        }
        classLoadersWorking = AdditionOrderedSet.dedup(classLoadersWorking);
        HashSet<ClassLoader> ancestralClassLoaders = new HashSet<ClassLoader>(classLoadersWorking.size());
        for (ClassLoader classLoader : classLoadersWorking) {
            for (ClassLoader cl = classLoader.getParent(); cl != null; cl = cl.getParent()) {
                ancestralClassLoaders.add(cl);
            }
        }
        ArrayList<ClassLoader> classLoaderOrder = new ArrayList<ClassLoader>(classLoadersWorking.size());
        for (ClassLoader classLoader : classLoadersWorking) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderOrder.add(classLoader);
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader cl : classLoaderOrder) {
                classLoadersFoundLog.log("" + cl);
            }
        }
        return classLoaderOrder;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

