/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastManifestParser;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClasspathElementZip
extends ClasspathElement {
    private File classpathEltZipFile;
    private FastManifestParser fastManifestParser;
    private Recycler<ZipFile, IOException> zipFileRecycler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClasspathElementZip(ClasspathRelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathRelativePath> workQueue, InterruptionChecker interruptionChecker, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles, interruptionChecker);
        try {
            this.classpathEltZipFile = classpathEltPath.getFile();
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
            }
            this.ioExceptionOnOpen = true;
            return;
        }
        if (this.classpathEltZipFile == null || !ClasspathUtils.canRead(this.classpathEltZipFile)) {
            if (log != null) {
                log.log("Skipping non-existent jarfile " + classpathEltPath.getResolvedPath());
            }
            this.ioExceptionOnOpen = true;
            return;
        }
        try {
            this.zipFileRecycler = nestedJarHandler.getZipFileRecycler(this.classpathEltZipFile.getPath());
        }
        catch (Exception e) {
            interruptionChecker.interrupt();
            if (log != null) {
                log.log("Exception while creating zipfile recycler", e);
            }
            this.ioExceptionOnOpen = true;
            return;
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = this.zipFileRecycler.acquire();
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception opening zipfile " + this.classpathEltZipFile, e);
                }
                this.ioExceptionOnOpen = true;
                this.zipFileRecycler.release(zipFile);
                return;
            }
            this.fastManifestParser = new FastManifestParser(zipFile, log);
            if (this.fastManifestParser != null && this.fastManifestParser.classPath != null) {
                LogNode manifestLog = log == null ? null : log.log("Manifest file META-INF/MANIFEST.MF has Class-Path entries");
                this.childClasspathElts = new ArrayList(this.fastManifestParser.classPath.size());
                String pathOfContainingDir = FastPathResolver.resolve(this.classpathEltZipFile.getParent());
                for (int i = 0; i < this.fastManifestParser.classPath.size(); ++i) {
                    String manifestClassPathEltPath = this.fastManifestParser.classPath.get(i);
                    ClasspathRelativePath childRelativePath = new ClasspathRelativePath(pathOfContainingDir, manifestClassPathEltPath, classpathEltPath.getClassLoaders(), nestedJarHandler);
                    this.childClasspathElts.add(childRelativePath);
                    if (manifestLog == null) continue;
                    manifestLog.log("Found Class-Path entry in manifest: " + manifestClassPathEltPath + " -> " + childRelativePath);
                }
                if (!this.childClasspathElts.isEmpty()) {
                    if (workQueue != null) {
                        workQueue.addWorkUnits(this.childClasspathElts);
                    } else if (log != null) {
                        log.log("Ignoring Class-Path entries in rt.jar: " + this.childClasspathElts);
                    }
                }
            }
            if (scanFiles) {
                this.fileMatches = new MultiMapKeyToList();
                this.classfileMatches = new ArrayList();
                this.fileToLastModified = new HashMap();
            }
        }
        finally {
            this.zipFileRecycler.release(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanPaths(LogNode log) {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = this.zipFileRecycler.acquire();
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception opening zipfile " + this.classpathEltZipFile, e);
                }
                this.ioExceptionOnOpen = true;
                this.zipFileRecycler.release(zipFile);
                return;
            }
            this.scanZipFile(this.classpathEltZipFile, zipFile, this.classpathEltPath.getZipClasspathBaseDir(), log);
        }
        finally {
            this.zipFileRecycler.release(zipFile);
        }
    }

    private void scanZipFile(File zipFileFile, ZipFile zipFile, String classpathBaseDir, LogNode log) {
        String requiredPrefix;
        if (!classpathBaseDir.isEmpty()) {
            if (log != null) {
                log.log("Classpath prefix within jarfile: " + classpathBaseDir);
            }
            requiredPrefix = classpathBaseDir + "/";
        } else {
            requiredPrefix = "";
        }
        int requiredPrefixLen = requiredPrefix.length();
        ArrayList nestedClasspathRootsList = null;
        if (this.nestedClasspathRoots != null) {
            nestedClasspathRootsList = new ArrayList(this.nestedClasspathRoots);
        }
        HashSet<String> loggedNestedClasspathRoots = null;
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        int entryIdx = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            int lastSlashIdx;
            if ((entryIdx++ & 0x3FF) == 0 && this.interruptionChecker.checkAndReturn()) {
                return;
            }
            ZipEntry zipEntry = entries.nextElement();
            boolean isDir = zipEntry.isDirectory();
            if (isDir) continue;
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (requiredPrefixLen > 0) {
                if (!relativePath.startsWith(requiredPrefix)) continue;
                relativePath = relativePath.substring(requiredPrefixLen);
            }
            String parentRelativePath = (lastSlashIdx = relativePath.lastIndexOf("/")) < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
            if (nestedClasspathRootsList != null) {
                for (String nestedClasspathRoot : nestedClasspathRootsList) {
                    if (!relativePath.startsWith(nestedClasspathRoot) || log == null) continue;
                    if (loggedNestedClasspathRoots == null) {
                        loggedNestedClasspathRoots = new HashSet<String>();
                    }
                    if (!loggedNestedClasspathRoots.add(nestedClasspathRoot)) continue;
                    log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + nestedClasspathRoot);
                }
            }
            if (log != null) {
                log.log("Found whitelisted file: " + relativePath);
            }
            if (ClasspathRelativePath.isClassfile(relativePath)) {
                this.classfileMatches.add(new ClasspathElement.ClasspathResource.ClasspathResourceInZipFile(zipFileFile, requiredPrefix + relativePath, relativePath, zipEntry));
            }
            for (ScanSpec.FilePathTesterAndMatchProcessorWrapper fileMatcher : this.scanSpec.getFilePathTestersAndMatchProcessorWrappers()) {
                if (!fileMatcher.filePathMatches(zipFileFile, relativePath, log)) continue;
                this.fileMatches.put(fileMatcher.fileMatchProcessorWrapper, new ClasspathElement.ClasspathResource.ClasspathResourceInZipFile(zipFileFile, requiredPrefix + relativePath, relativePath, zipEntry));
            }
        }
        this.fileToLastModified.put(zipFileFile, zipFileFile.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openInputStreamAndProcessFileMatch(ClasspathElement.ClasspathResource fileMatchResource, ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper) throws IOException {
        if (!this.ioExceptionOnOpen) {
            ZipFile zipFile = null;
            try {
                zipFile = this.zipFileRecycler.acquire();
                ClasspathElement.ClasspathResource.ClasspathResourceInZipFile classpathResourceInZipFile = (ClasspathElement.ClasspathResource.ClasspathResourceInZipFile)fileMatchResource;
                ZipEntry zipEntry = classpathResourceInZipFile.zipEntry;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    fileMatchProcessorWrapper.processMatch(classpathResourceInZipFile.classpathEltFile, classpathResourceInZipFile.pathRelativeToClasspathPrefix, inputStream, zipEntry.getSize());
                }
            }
            finally {
                this.zipFileRecycler.release(zipFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openInputStreamAndParseClassfile(ClasspathElement.ClasspathResource classfileResource, ClassfileBinaryParser classfileBinaryParser, ScanSpec scanSpec, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws IOException, InterruptedException {
        if (!this.ioExceptionOnOpen) {
            ZipFile zipFile = null;
            try {
                zipFile = this.zipFileRecycler.acquire();
                ClasspathElement.ClasspathResource.ClasspathResourceInZipFile classpathResourceInZipFile = (ClasspathElement.ClasspathResource.ClasspathResourceInZipFile)classfileResource;
                ZipEntry zipEntry = classpathResourceInZipFile.zipEntry;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(this, classpathResourceInZipFile.pathRelativeToClasspathPrefix, inputStream, scanSpec, stringInternMap, log);
                    if (thisClassInfoUnlinked != null) {
                        classInfoUnlinked.add(thisClassInfoUnlinked);
                        thisClassInfoUnlinked.logTo(log);
                    }
                }
            }
            finally {
                this.zipFileRecycler.release(zipFile);
            }
        }
    }

    @Override
    public void close() {
        if (this.zipFileRecycler != null) {
            this.zipFileRecycler.close();
        }
    }
}

