/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.EquinoxClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.FelixClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.JBossClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.Java9ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.OSGiDefaultClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.URLClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WeblogicClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WebsphereLibertyClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.WebsphereTraditionalClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.util.Arrays;
import java.util.List;

public class ClassLoaderHandlerRegistry {
    public static final List<ClassLoaderHandlerRegistryEntry> DEFAULT_CLASS_LOADER_HANDLERS = Arrays.asList(new ClassLoaderHandlerRegistryEntry(EquinoxClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(FelixClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(JBossClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WeblogicClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WebsphereLibertyClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(WebsphereTraditionalClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(OSGiDefaultClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(Java9ClassLoaderHandler.class), new ClassLoaderHandlerRegistryEntry(URLClassLoaderHandler.class));

    public static class ClassLoaderHandlerRegistryEntry {
        public final String[] handledClassLoaderNames;
        public final Class<? extends ClassLoaderHandler> classLoaderHandlerClass;

        public ClassLoaderHandlerRegistryEntry(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
            Object handledClassLoaders;
            String fieldName = "HANDLED_CLASSLOADERS";
            try {
                handledClassLoaders = ReflectionUtils.getStaticFieldVal(classLoaderHandlerClass, "HANDLED_CLASSLOADERS");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Could not read field " + classLoaderHandlerClass + "." + "HANDLED_CLASSLOADERS", e);
            }
            if (handledClassLoaders == null) {
                throw new RuntimeException("Class " + classLoaderHandlerClass + " needs a non-null static String[] field " + "HANDLED_CLASSLOADERS");
            }
            if (!handledClassLoaders.getClass().isArray() || handledClassLoaders.getClass().getComponentType() != String.class) {
                throw new RuntimeException("Field " + classLoaderHandlerClass + "." + "HANDLED_CLASSLOADERS" + " has incorrect type, should be String[]");
            }
            this.handledClassLoaderNames = (String[])handledClassLoaders;
            this.classLoaderHandlerClass = classLoaderHandlerClass;
        }
    }
}

