/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ClassLoaderAndModuleFinder {
    private final ClassLoader[] classLoaders;
    private final List<ModuleRef> systemModuleRefs;
    private final List<ModuleRef> nonSystemModuleRefs;
    private static CallerResolver CALLER_RESOLVER;

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderAndModuleFinder(ScanSpec scanSpec, LogNode log) {
        AdditionOrderedSet<Object> classLoadersUnique;
        LogNode classLoadersFoundLog = null;
        ArrayList<ModuleRef> systemModuleRefs = null;
        ArrayList<ModuleRef> nonSystemModuleRefs = null;
        if (scanSpec == null || scanSpec.overrideClassLoaders == null) {
            Object threadClassLoader;
            classLoadersUnique = new AdditionOrderedSet();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                classLoadersUnique.add(systemClassLoader);
            }
            if (CALLER_RESOLVER == null) {
                if (log != null) {
                    log.log(ClassLoaderAndModuleFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
                }
            } else {
                Class<?>[] callStack = CALLER_RESOLVER.getClassContext();
                if (callStack == null) {
                    if (log != null) {
                        log.log(ClassLoaderAndModuleFinder.class.getSimpleName() + ": " + CallerResolver.class.getSimpleName() + "#getClassContext() returned null");
                    }
                } else {
                    void var9_10;
                    int n = callStack.length - 1;
                    while (var9_10 >= 0) {
                        ClassLoader classLoader = callStack[var9_10].getClassLoader();
                        if (classLoader != null) {
                            classLoadersUnique.add(classLoader);
                        }
                        --var9_10;
                    }
                    List<ModuleRef> list = ModuleRef.findModuleRefs(callStack);
                    systemModuleRefs = new ArrayList<ModuleRef>();
                    nonSystemModuleRefs = new ArrayList<ModuleRef>();
                    for (ModuleRef moduleRef : list) {
                        if (JarUtils.isInSystemPackageOrModule(moduleRef.getModuleName())) {
                            systemModuleRefs.add(moduleRef);
                            continue;
                        }
                        nonSystemModuleRefs.add(moduleRef);
                    }
                }
            }
            if ((threadClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(threadClassLoader);
            }
            if (scanSpec != null && scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new AdditionOrderedSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            void var10_22;
            ClassLoader classLoader2 = classLoader.getParent();
            while (var10_22 != null) {
                ancestralClassLoaders.add(var10_22);
                ClassLoader classLoader3 = var10_22.getParent();
            }
        }
        ArrayList<ClassLoader> classLoaderFinalOrder = new ArrayList<ClassLoader>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log("" + classLoader);
            }
        }
        if (log != null) {
            LogNode logNode = log.log("Found system modules:");
            if (systemModuleRefs != null && !systemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : systemModuleRefs) {
                    logNode.log(moduleRef.toString());
                }
            } else {
                logNode.log("[None]");
            }
            LogNode logNode2 = log.log("Found non-system modules:");
            if (nonSystemModuleRefs != null && !nonSystemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : nonSystemModuleRefs) {
                    logNode2.log(moduleRef.toString());
                }
            } else {
                logNode2.log("[None]");
            }
        }
        this.classLoaders = classLoaderFinalOrder.toArray(new ClassLoader[classLoaderFinalOrder.size()]);
        this.systemModuleRefs = systemModuleRefs;
        this.nonSystemModuleRefs = nonSystemModuleRefs;
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

