/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FieldInfo
extends ScanResult.InfoObject
implements Comparable<FieldInfo> {
    transient String className;
    String fieldName;
    int modifiers;
    String typeSignatureStr;
    String typeDescriptorStr;
    transient TypeSignature typeSignature;
    transient TypeSignature typeDescriptor;
    Object constValue;
    List<AnnotationInfo> annotationInfo;
    transient ScanResult scanResult;

    FieldInfo() {
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
    }

    public FieldInfo(String className, String fieldName, int modifiers, String typeDescriptorStr, String typeSignatureStr, Object constValue, List<AnnotationInfo> annotationInfo) {
        this.className = className;
        this.fieldName = fieldName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.constValue = constValue;
        this.annotationInfo = annotationInfo == null || annotationInfo.isEmpty() ? null : annotationInfo;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Deprecated
    public String getModifierStrs() {
        return this.getModifierStr();
    }

    public String getModifierStr() {
        return TypeUtils.modifiersToString(this.modifiers, false);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getTypeDescriptorStr() {
        return this.typeDescriptorStr;
    }

    public TypeSignature getTypeDescriptor() {
        if (this.typeDescriptorStr == null) {
            return null;
        }
        if (this.typeDescriptor == null) {
            try {
                this.typeDescriptor = TypeSignature.parse(this.typeDescriptorStr);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeDescriptor;
    }

    public String getTypeSignatureStr() {
        return this.typeSignatureStr;
    }

    public TypeSignature getTypeSignature() {
        if (this.typeSignatureStr == null) {
            return null;
        }
        if (this.typeSignature == null) {
            try {
                this.typeSignature = TypeSignature.parse(this.typeSignatureStr);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    public TypeSignature getTypeSignatureOrTypeDescriptor() {
        TypeSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig;
        }
        return this.getTypeDescriptor();
    }

    public Class<?> getType() throws IllegalArgumentException {
        return this.getTypeDescriptor().instantiate(this.scanResult);
    }

    public Object getConstFinalValue() {
        return this.constValue;
    }

    public List<String> getAnnotationNames() {
        return this.annotationInfo == null ? Collections.emptyList() : Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        return this.className.equals(other.className) && this.fieldName.equals(other.fieldName);
    }

    public int hashCode() {
        return this.fieldName.hashCode() + this.className.hashCode() * 11;
    }

    @Override
    public int compareTo(FieldInfo other) {
        int diff = this.className.compareTo(other.className);
        if (diff != 0) {
            return diff;
        }
        return this.fieldName.compareTo(other.fieldName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(annotation.toString());
            }
        }
        if (this.modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            TypeUtils.modifiersToString(this.modifiers, false, buf);
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getTypeSignatureOrTypeDescriptor().toString());
        buf.append(' ');
        buf.append(this.fieldName);
        if (this.constValue != null) {
            buf.append(" = ");
            if (this.constValue instanceof String) {
                buf.append("\"" + ((String)this.constValue).replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
            } else if (this.constValue instanceof Character) {
                buf.append("'" + ((Character)this.constValue).toString().replace("\\", "\\\\").replaceAll("'", "\\'") + "'");
            } else {
                buf.append(this.constValue.toString());
            }
        }
        return buf.toString();
    }
}

