/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.common;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.istio.common.Event;
import com.alibaba.nacos.istio.common.EventProcessor;
import com.alibaba.nacos.istio.model.IstioService;
import com.alibaba.nacos.istio.util.IstioCrdUtil;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosServiceInfoResourceWatcher
implements Runnable {
    private final Map<String, IstioService> serviceInfoMap = new ConcurrentHashMap<String, IstioService>(16);
    @Autowired
    private ServiceStorage serviceStorage;
    @Autowired
    private EventProcessor eventProcessor;

    @Override
    public void run() {
        boolean changed = false;
        Set namespaces = ServiceManager.getInstance().getAllNamespaces();
        HashSet<String> allServices = new HashSet<String>();
        for (String namespace : namespaces) {
            Set services = ServiceManager.getInstance().getSingletons(namespace);
            if (services.isEmpty()) continue;
            for (com.alibaba.nacos.naming.core.v2.pojo.Service service : services) {
                String serviceName = IstioCrdUtil.buildServiceNameForServiceEntry(service);
                allServices.add(serviceName);
                IstioService old = this.serviceInfoMap.get(serviceName);
                if (old != null && old.getRevision().equals(service.getRevision())) continue;
                changed = true;
                ServiceInfo serviceInfo = this.serviceStorage.getPushData(service);
                if (!serviceInfo.isValid()) {
                    this.serviceInfoMap.remove(serviceName);
                    continue;
                }
                if (old != null) {
                    this.serviceInfoMap.put(serviceName, new IstioService(service, serviceInfo, old));
                    continue;
                }
                this.serviceInfoMap.put(serviceName, new IstioService(service, serviceInfo));
            }
        }
        for (String key : this.serviceInfoMap.keySet()) {
            if (allServices.contains(key)) continue;
            changed = true;
            this.serviceInfoMap.remove(key);
        }
        if (changed) {
            this.eventProcessor.notify(Event.SERVICE_UPDATE_EVENT);
        }
    }

    public Map<String, IstioService> snapshot() {
        return new HashMap<String, IstioService>(this.serviceInfoMap);
    }
}

