/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.cluster;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.core.distributed.distro.DistroProtocol;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class ServerStatusManager {
    private final GlobalConfig globalConfig;
    private final DistroProtocol distroProtocol;
    private final ProtocolManager protocolManager;
    private final SwitchDomain switchDomain;
    private ServerStatus serverStatus = ServerStatus.STARTING;

    public ServerStatusManager(GlobalConfig globalConfig, DistroProtocol distroProtocol, ProtocolManager protocolManager, SwitchDomain switchDomain) {
        this.globalConfig = globalConfig;
        this.distroProtocol = distroProtocol;
        this.protocolManager = protocolManager;
        this.switchDomain = switchDomain;
    }

    @PostConstruct
    public void init() {
        GlobalExecutor.registerServerStatusUpdater(new ServerStatusUpdater());
    }

    private void refreshServerStatus() {
        if (StringUtils.isNotBlank((String)this.switchDomain.getOverriddenServerStatus())) {
            this.serverStatus = ServerStatus.valueOf(this.switchDomain.getOverriddenServerStatus());
            return;
        }
        this.serverStatus = this.isReady() ? ServerStatus.UP : ServerStatus.DOWN;
    }

    private boolean isReady() {
        if (!this.globalConfig.isDataWarmup()) {
            return true;
        }
        if (!this.protocolManager.isCpInit() || this.protocolManager.getCpProtocol() == null) {
            return false;
        }
        return this.protocolManager.getCpProtocol().isReady() && this.distroProtocol.isInitialized();
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public Optional<String> getErrorMsg() {
        if (this.isReady()) {
            return Optional.empty();
        }
        if (!this.distroProtocol.isInitialized()) {
            return Optional.of("Distro snapshot load failed, please see logs `protocol-distro.log` or `naming-distro.log` to see details.");
        }
        return Optional.of("No leader for raft, please see logs `alipay-jraft.log` or `naming-raft.log` to see details.");
    }

    public class ServerStatusUpdater
    implements Runnable {
        @Override
        public void run() {
            ServerStatusManager.this.refreshServerStatus();
        }
    }
}

