/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.event.publisher;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.EventPublisher;
import com.alibaba.nacos.common.notify.EventPublisherFactory;
import com.alibaba.nacos.naming.core.v2.event.publisher.NamingEventPublisher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NamingEventPublisherFactory
implements EventPublisherFactory {
    private static final NamingEventPublisherFactory INSTANCE = new NamingEventPublisherFactory();
    private final Map<Class<? extends Event>, NamingEventPublisher> publisher = new ConcurrentHashMap<Class<? extends Event>, NamingEventPublisher>();

    private NamingEventPublisherFactory() {
    }

    public static NamingEventPublisherFactory getInstance() {
        return INSTANCE;
    }

    public EventPublisher apply(Class<? extends Event> eventType, Integer maxQueueSize) {
        Class<Object> cachedEventType = eventType.isMemberClass() ? eventType.getEnclosingClass() : eventType;
        return (EventPublisher)this.publisher.computeIfAbsent(cachedEventType, eventClass -> {
            NamingEventPublisher result = new NamingEventPublisher();
            result.init((Class<? extends Event>)eventClass, maxQueueSize);
            return result;
        });
    }

    public String getAllPublisherStatues() {
        StringBuilder result = new StringBuilder("Naming event publisher statues:\n");
        for (NamingEventPublisher each : this.publisher.values()) {
            result.append('\t').append(each.getStatus()).append('\n');
        }
        return result.toString();
    }
}

