/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.paramcheck;

import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class NamingInstanceBeatHttpParamExtractor
extends AbstractHttpParamExtractor {
    public List<ParamInfo> extractParam(HttpServletRequest request) {
        ParamInfo paramInfo = new ParamInfo();
        String serviceName = request.getParameter("serviceName");
        String groupName = request.getParameter("groupName");
        String groupServiceName = serviceName;
        if (StringUtils.isNotBlank((String)groupServiceName) && groupServiceName.contains("@@")) {
            String[] splits = groupServiceName.split("@@", 2);
            groupName = splits[0];
            serviceName = splits[1];
        }
        paramInfo.setServiceName(serviceName);
        paramInfo.setGroup(groupName);
        paramInfo.setIp(request.getParameter("ip"));
        paramInfo.setPort(request.getParameter("port"));
        paramInfo.setNamespaceId(request.getParameter("namespaceId"));
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>();
        paramInfos.add(paramInfo);
        String beatString = request.getParameter("beat");
        if (StringUtils.isNotBlank((String)beatString)) {
            RsInfo clientBeat = (RsInfo)JacksonUtils.toObj((String)beatString, RsInfo.class);
            ParamInfo beatParamInfo = new ParamInfo();
            beatParamInfo.setIp(clientBeat.getIp());
            beatParamInfo.setPort(String.valueOf(clientBeat.getPort()));
            beatParamInfo.setCluster(clientBeat.getCluster());
            paramInfos.add(beatParamInfo);
        }
        return paramInfos;
    }
}

