/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.hook;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.pojo.Subscriber;

public class PushResult {
    private final boolean pushSuccess;
    private final String subscribeClientId;
    private final Service service;
    private final ServiceInfo data;
    private final Subscriber subscriber;
    private final long networkCost;
    private final long allCost;
    private final long sla;
    private final Throwable exception;
    private final boolean isPushToAll;

    private PushResult(boolean pushSuccess, String subscribeClientId, Service service, ServiceInfo data, Subscriber subscriber, long networkCost, long allCost, long sla, Throwable exception, boolean isPushToAll) {
        this.pushSuccess = pushSuccess;
        this.subscribeClientId = subscribeClientId;
        this.service = service;
        this.data = data;
        this.subscriber = subscriber;
        this.networkCost = networkCost;
        this.allCost = allCost;
        this.sla = sla;
        this.exception = exception;
        this.isPushToAll = isPushToAll;
    }

    public static PushResult pushSuccess(Service service, String subscribeClientId, ServiceInfo data, Subscriber subscriber, long networkCost, long allCost, long sla, boolean isPushToAll) {
        return new PushResult(true, subscribeClientId, service, data, subscriber, networkCost, allCost, sla, null, isPushToAll);
    }

    public static PushResult pushFailed(Service service, String subscribeClientId, ServiceInfo data, Subscriber subscriber, long allCost, Throwable exception, boolean isPushToAll) {
        return new PushResult(false, subscribeClientId, service, data, subscriber, -1L, allCost, -1L, exception, isPushToAll);
    }

    public boolean isPushSuccess() {
        return this.pushSuccess;
    }

    public String getSubscribeClientId() {
        return this.subscribeClientId;
    }

    public Service getService() {
        return this.service;
    }

    public ServiceInfo getData() {
        return this.data;
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public long getNetworkCost() {
        return this.networkCost;
    }

    public long getAllCost() {
        return this.allCost;
    }

    public long getSla() {
        return this.sla;
    }

    public Throwable getException() {
        return this.exception;
    }
}

