/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.remote.rpc.handler;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.remote.request.BatchInstanceRequest;
import com.alibaba.nacos.api.naming.remote.response.BatchInstanceResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.BatchInstanceRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.impl.EphemeralClientOperationServiceImpl;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.springframework.stereotype.Component;

@Component(value="batchInstanceRequestHandler")
public class BatchInstanceRequestHandler
extends RequestHandler<BatchInstanceRequest, BatchInstanceResponse> {
    private final EphemeralClientOperationServiceImpl clientOperationService;

    public BatchInstanceRequestHandler(EphemeralClientOperationServiceImpl clientOperationService) {
        this.clientOperationService = clientOperationService;
    }

    @TpsControl(pointName="RemoteNamingInstanceBatchRegister", name="RemoteNamingInstanceBatchRegister")
    @Secured(action=ActionTypes.WRITE)
    @ExtractorManager.Extractor(rpcExtractor=BatchInstanceRequestParamExtractor.class)
    public BatchInstanceResponse handle(BatchInstanceRequest request, RequestMeta meta) throws NacosException {
        Service service = Service.newService(request.getNamespace(), request.getGroupName(), request.getServiceName(), true);
        InstanceUtil.batchSetInstanceIdIfEmpty(request.getInstances(), service.getGroupedServiceName());
        switch (request.getType()) {
            case "batchRegisterInstance": {
                return this.batchRegisterInstance(service, request, meta);
            }
        }
        throw new NacosException(400, String.format("Unsupported request type %s", request.getType()));
    }

    private BatchInstanceResponse batchRegisterInstance(Service service, BatchInstanceRequest request, RequestMeta meta) {
        this.clientOperationService.batchRegisterInstance(service, request.getInstances(), meta.getConnectionId());
        return new BatchInstanceResponse("batchRegisterInstance");
    }
}

