/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.selector;

import com.alibaba.nacos.api.cmdb.pojo.Entity;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.selector.AbstractCmdbSelector;
import com.alibaba.nacos.api.selector.context.CmdbContext;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.selector.interpreter.ExpressionInterpreter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LabelSelector<T extends Instance>
extends AbstractCmdbSelector<T> {
    private static final String TYPE = "label";
    private Set<String> labels;

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels;
    }

    protected List<T> doSelect(CmdbContext<T> context) {
        if (CollectionUtils.isEmpty(this.labels)) {
            return context.getProviders().stream().map(CmdbContext.CmdbInstance::getInstance).collect(Collectors.toList());
        }
        CmdbContext.CmdbInstance consumer = context.getConsumer();
        Map consumerLabels = Optional.ofNullable(consumer.getEntity()).map(Entity::getLabels).orElse(Collections.emptyMap());
        List result = context.getProviders().stream().filter(ci -> {
            Entity providerEntity = ci.getEntity();
            if (Objects.isNull(providerEntity)) {
                return false;
            }
            Map providerLabels = Optional.ofNullable(ci.getEntity().getLabels()).orElse(Collections.emptyMap());
            return this.labels.stream().allMatch(label -> {
                String consumerLabelValue = (String)consumerLabels.get(label);
                if (StringUtils.isBlank((CharSequence)consumerLabelValue)) {
                    return false;
                }
                return Objects.equals(consumerLabelValue, providerLabels.get(label));
            });
        }).map(CmdbContext.CmdbInstance::getInstance).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(result)) {
            return context.getProviders().stream().map(CmdbContext.CmdbInstance::getInstance).collect(Collectors.toList());
        }
        return result;
    }

    protected void doParse(String expression) throws NacosException {
        this.labels = ExpressionInterpreter.parseExpression(expression);
    }

    public String getType() {
        return TYPE;
    }
}

