/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.Supplier;

public interface VavrCircuitBreaker {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(CircuitBreaker circuitBreaker, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object returnValue = supplier.apply();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
                return returnValue;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)exception);
                throw exception;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(CircuitBreaker circuitBreaker, CheckedRunnable runnable) {
        return () -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                runnable.run();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)exception);
                throw exception;
            }
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(CircuitBreaker circuitBreaker, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            if (circuitBreaker.tryAcquirePermission()) {
                long start = circuitBreaker.getCurrentTimestamp();
                Either result = (Either)supplier.get();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                if (result.isRight()) {
                    circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
                } else {
                    Exception exception = (Exception)result.getLeft();
                    circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)exception);
                }
                return Either.narrow((Either)result);
            }
            return Either.left((Object)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)circuitBreaker));
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(CircuitBreaker circuitBreaker, Supplier<Try<T>> supplier) {
        return () -> {
            if (circuitBreaker.tryAcquirePermission()) {
                long start = circuitBreaker.getCurrentTimestamp();
                Try result = (Try)supplier.get();
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                if (result.isSuccess()) {
                    circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
                    return result;
                }
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), result.getCause());
                return result;
            }
            return Try.failure((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)circuitBreaker));
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(CircuitBreaker circuitBreaker, CheckedConsumer<T> consumer) {
        return t -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                consumer.accept(t);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)exception);
                throw exception;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(CircuitBreaker circuitBreaker, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            circuitBreaker.acquirePermission();
            long start = circuitBreaker.getCurrentTimestamp();
            try {
                Object returnValue = function.apply(t);
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onSuccess(duration, circuitBreaker.getTimestampUnit());
                return returnValue;
            }
            catch (Exception exception) {
                long duration = circuitBreaker.getCurrentTimestamp() - start;
                circuitBreaker.onError(duration, circuitBreaker.getTimestampUnit(), (Throwable)exception);
                throw exception;
            }
        };
    }

    public static <T> Either<Exception, T> executeEitherSupplier(CircuitBreaker circuitBreaker, Supplier<Either<? extends Exception, T>> supplier) {
        return VavrCircuitBreaker.decorateEitherSupplier(circuitBreaker, supplier).get();
    }

    public static <T> Try<T> executeTrySupplier(CircuitBreaker circuitBreaker, Supplier<Try<T>> supplier) {
        return VavrCircuitBreaker.decorateTrySupplier(circuitBreaker, supplier).get();
    }

    public static <T> T executeCheckedSupplier(CircuitBreaker circuitBreaker, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)VavrCircuitBreaker.decorateCheckedSupplier(circuitBreaker, checkedSupplier).apply();
    }

    public static void executeCheckedRunnable(CircuitBreaker circuitBreaker, CheckedRunnable runnable) throws Throwable {
        VavrCircuitBreaker.decorateCheckedRunnable(circuitBreaker, runnable).run();
    }
}

